/*
 * Adobe Confidential
 *
 * Copyright 2003 Adobe Systems Incorporated.  All Rights Reserved.
 *
 * Notice: all information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any.  The intellectual and 
 * technical concepts contained herein are proprietary to Adobe Systems Inc.
 * and its suppliers and may be covered by U.S. and foreign patents, patents in 
 * process, and are protected by trade secret or copyright law.  Dissemination 
 * of this information or reproduction of this material is strictly forbidden 
 * unless prior written permission is obtained from Adobe Systems Inc.
 */

package com.adobe.xfa.connectionset;

import com.adobe.xfa.ChildReln;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.STRS;
import com.adobe.xfa.Schema;
import com.adobe.xfa.XFA;


/**
 * A class which defines the valid node relationships in XFA connectionSet.
 *
 * @exclude from published api.
 */
public final class ConnectionSetSchema extends Schema {

	/**
	 */
	public ConnectionSetSchema() {
		super(STRS.XFACONNECTIONSETNS,
				XFA.XFA_ATTRIBUTE_MIN, 
				XFA.XFA_ATTRIBUTE_MAX, 
				XFA.XFA_ELEMENT_MIN, 
				XFA.XFA_ELEMENT_MAX);
		initSchema();
	}

	protected void initSchema() {
		super.initSchema();
		//
		// add elements defined in XFASchema
		//
		// Don't add TextNode since it is not an Element

		//
		// rootElement
		//
		putChildAttrs(XFA.ROOTELEMENTTAG);
		putElement(XFA.ROOTELEMENTTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL67504 Sep 26, 2003
		//
		// uri
		//
		putChildAttrs(XFA.URITAG);
		putElement(XFA.URITAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL67504 Sep 26, 2003
		//
		// soapAction
		//
		putChildAttrs(XFA.SOAPACTIONTAG);
		putElement(XFA.SOAPACTIONTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL69163 Oct 7, 2003
		//
		// soapAddress
		//
		putChildAttrs(XFA.SOAPADDRESSTAG);
		putElement(XFA.SOAPADDRESSTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL69163 Oct 7, 2003
		//
		// wsdlAddress
		//
		putChildAttrs(XFA.WSDLADDRESSTAG);
		putElement(XFA.WSDLADDRESSTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL69163 Oct 7, 2003
		//
		// operation
		//
		putChildAttrs(XFA.OPERATIONTAG);
		putElement(XFA.OPERATIONTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL69645 Oct 13, 2003
		putAttribute(XFA.OPERATIONTAG, XFA.INPUTTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL69645 Oct 13, 2003
		putAttribute(XFA.OPERATIONTAG, XFA.OUTPUTTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL69645 Oct 13, 2003
		//
		// effectiveInputPolicy
		//
		putChildAttrs(XFA.EFFECTIVEINPUTPOLICYTAG);
		// <wsp:Policy> children excluded by XFAConnectionSetModelImpl::loadNode()
		//
		// effectiveOutputPolicy
		//
		putChildAttrs(XFA.EFFECTIVEOUTPUTPOLICYTAG);
		// <wsp:Policy> children excluded by XFAConnectionSetModelImpl::loadNode()
		//
		// xmlConnection 
		//
		putAttribute(XFA.XMLCONNECTIONTAG, XFA.NAMETAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL67504 Sep 26, 2003
		putAttribute(XFA.XMLCONNECTIONTAG, XFA.DATADESCRIPTIONTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL67504 Sep 26, 2003
		putElement(XFA.XMLCONNECTIONTAG, XFA.URITAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL67504 Sep 26, 2003
		//
		// xsdConnection 
		//
		putAttribute(XFA.XSDCONNECTIONTAG, XFA.NAMETAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL67504 Sep 26, 2003
		putAttribute(XFA.XSDCONNECTIONTAG, XFA.DATADESCRIPTIONTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL67504 Sep 26, 2003
		putElement(XFA.XSDCONNECTIONTAG, XFA.URITAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL67504 Sep 26, 2003
		putElement(XFA.XSDCONNECTIONTAG, XFA.ROOTELEMENTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL67504 Sep 26, 2003
		//
		// wsdlConnection 
		//
		putAttribute(XFA.WSDLCONNECTIONTAG, XFA.NAMETAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL67504 Sep 26, 2003
		putAttribute(XFA.WSDLCONNECTIONTAG, XFA.DATADESCRIPTIONTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL67504 Sep 26, 2003
		putElement(XFA.WSDLCONNECTIONTAG, XFA.SOAPACTIONTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL69163 Oct 7, 2003
		putElement(XFA.WSDLCONNECTIONTAG, XFA.SOAPADDRESSTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL69163 Oct 7, 2003
		putElement(XFA.WSDLCONNECTIONTAG, XFA.WSDLADDRESSTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL69163 Oct 7, 2003
		putElement(XFA.WSDLCONNECTIONTAG, XFA.OPERATIONTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL69645 Oct 13, 2003
		putElement(XFA.WSDLCONNECTIONTAG, XFA.EFFECTIVEINPUTPOLICYTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0);
		putElement(XFA.WSDLCONNECTIONTAG, XFA.EFFECTIVEOUTPUTPOLICYTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0);
		//
		// connectionSet
		//
		putElement(XFA.CONNECTIONSETTAG, XFA.XMLCONNECTIONTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL67504 Sep 26, 2003
		putElement(XFA.CONNECTIONSETTAG, XFA.XSDCONNECTIONTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL67504 Sep 26, 2003
		putElement(XFA.CONNECTIONSETTAG, XFA.WSDLCONNECTIONTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL, /* 0, */ 0); // Added with CL67504 Sep 26, 2003
	}
	

	protected Element newElement(int eTag, Element parent, Node prevSibling) {
		
		switch (eTag) {

		// TextNode is not an Element!
		//case XFA.TEXTNODETAG: return new com.adobe.xfa.TextNode(parent, prevSibling);
		
		case XFA.XMLCONNECTIONTAG: return new com.adobe.xfa.connectionset.XMLConnection(parent, prevSibling);
		case XFA.XSDCONNECTIONTAG: return new com.adobe.xfa.connectionset.XSDConnection(parent, prevSibling);
		case XFA.WSDLCONNECTIONTAG: return new com.adobe.xfa.connectionset.WSDLConnection(parent, prevSibling);
		case XFA.CONNECTIONSETTAG: return new com.adobe.xfa.connectionset.ConnectionSetModel(parent, prevSibling);
		case XFA.EFFECTIVEINPUTPOLICYTAG: return new com.adobe.xfa.connectionset.EffectiveInputPolicy(parent, prevSibling);
		case XFA.EFFECTIVEOUTPUTPOLICYTAG: return new com.adobe.xfa.connectionset.EffectiveOutputPolicy(parent, prevSibling);
		
		case XFA.ROOTELEMENTTAG:
		case XFA.URITAG:
		case XFA.SOAPACTIONTAG:
		case XFA.SOAPADDRESSTAG:
		case XFA.WSDLADDRESSTAG:
		case XFA.OPERATIONTAG:
			return new com.adobe.xfa.GenericTextContainer(parent, prevSibling);
			
		default:
			return null;
		}
	}
}
