/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated. All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa.connectionset;


import com.adobe.xfa.Dispatcher;
import com.adobe.xfa.Element;
import com.adobe.xfa.EventManager;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.XFA;


/**
 * @exclude from published api.
 */
public class WSDLConnection extends ProtoableNode {

    /**
     * Constructor.
     */
	public WSDLConnection(Element parent, Node prevSibling) {
		super(parent, prevSibling,
					null, XFA.WSDLCONNECTION, XFA.WSDLCONNECTION,
							null, XFA.WSDLCONNECTIONTAG, XFA.WSDLCONNECTION);
	}

	/**
	 * watson 1478951: special case cloning for <wsdlConnection> nodes such that they
	 * will inherit a copy of the source node's event table.  This allows cloned
	 * orphan <wsdlConnection> nodes to be able to trigger script that referenced
	 * the source node.
	 */
	public Element clone(Element oParent, boolean deep) {
		// defer bulk of cloning to ProtoableNode
		Element oClone = super.clone(oParent, deep);
		assert(oClone != null);
		if (oClone != null) {
			// get our event table
			Element oThis = (WSDLConnection) this;
			EventManager.EventTable oEventTable = oThis.getEventTable(false);
			if (oEventTable != null) {
				// generate event table for clone
				EventManager.EventTable oCloneEventTable = oClone.getEventTable(true);
				assert(oCloneEventTable != null);
				if (oCloneEventTable != null) {
					// iterate over our event table
					int nSize = oEventTable.size();
					for (int nIndex = 0; nIndex < nSize; nIndex++) {
						// copy dispatcher to clone event table
						Dispatcher oDispatcher = oEventTable.get(nIndex);
						oCloneEventTable.add(nIndex, oDispatcher);
					}
				}
			}
		}
		return oClone;
	}

	/**
	 * Adobe patent application tracking # P624,
	 * entitled "Form-based Data Storage And Retrieval", inventors: Matveief,Young,Solc
	 */
	public boolean execute(boolean inDoDynamicMerge) {
		boolean bResult = false;
		Model oModel = getModel();
		if (oModel instanceof  ConnectionSetModel) {
			ConnectionSetModel oConnectionSetModel = (ConnectionSetModel) oModel;
			bResult = oConnectionSetModel.execute(this, inDoDynamicMerge);
		}
		return bResult;
	}

	/**
	 * Permissions checking function for script calls or declarative operations
	 *
	 * @return true if ok, else false
	 */
	public boolean executePermsCheck() {
		// See Watson 1368015
		// For the "import" case, permission checks are done in FormModel.importConnectionData.
		// For the "remerge" case, it is too complicated to determine a priori if the remerge will
		// violate permissions, so the execute is simply allowed to proceed and break the signature.
		return true;
	}

	public ScriptTable getScriptTable() {
		return WSDLConnectionScript.getScriptTable();
	}

}
