/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.connectionset;


import com.adobe.xfa.Arg;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ProtoableNodeScript;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptFuncObj;
import com.adobe.xfa.ScriptTable;


/**
 * This class contains all the script functionality associated with the
 * WSDLConnection class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class WSDLConnectionScript extends ProtoableNodeScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ProtoableNodeScript.moScriptTable,
		"wsdlConnection",
		null,
		new ScriptFuncObj[] {
			new ScriptFuncObj(WSDLConnectionScript.class, "execute", "execute", Arg.BOOL,
				new int [] { Arg.BOOL, /*XFA_IS_CONNECTIONSET_EXECUTE_PARAM1*/}, 1,  Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_CONNECTIONSET_EXECUTE_DESC,  XFA_IS_CONNECTIONSET_EXECUTE_RET*/, "executePermsCheck", 0)
		}
	);
	
	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void execute(Obj obj, Arg retVal, Arg[] args) {
		boolean bResult = ((WSDLConnection) obj).execute(args[0].getAsBool(false));
		retVal.setBool(bResult);
	}

	public static boolean executePermsCheck(Obj obj, Arg[] args) {
		if (obj instanceof WSDLConnection)
			return ((WSDLConnection) obj).executePermsCheck();
		return true;
	}

}
