/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2009 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.dom;

import org.w3c.dom.Comment;
import org.w3c.dom.Node;

/**
 * Implements the W3C DOM Comment interface, wrapping an XFA DOM Comment.
 * @exclude from published api.
 */
class CommentImpl extends CharacterDataImpl implements Comment {

	CommentImpl (ParentNode parent, com.adobe.xfa.Comment newComment) {
		super (parent, newComment, newComment.getData());
//		debugInit ("Comment");
//		debug ("created");
	}

	public String getNodeName() {
		return COMMENT_NODE_NAME;
	}

	public short getNodeType() {
		return COMMENT_NODE;
	}

	public boolean isEqualNode(Node other) {
		if (this == other) {
			return true;
		}
		if (! super.isEqualNode (other)) {
			return false;
		}
		if (! (other instanceof CommentImpl)) {
			return false;
		}
		return true;	// currently nothing to compare for comment
	}
}
