/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2009 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.dom;

import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/**
 * Implements the W3C DOM Document interface, wrapping an XFA DOM Document.
 * @exclude from published api.
 */
class DocumentImpl extends ParentNode implements Document {
	static final String XML_VERSION = "1.1";

	private ElementImpl mDocumentElement;
	private final com.adobe.xfa.Document mXFADoc;

	DocumentImpl (com.adobe.xfa.Document xfaDoc) {
		super (null, xfaDoc);
		mXFADoc = xfaDoc;
//		debugInit ("Document");
//		debug ("created");
	}

	public Node adoptNode(Node source) throws DOMException {
		throw new DOMException (DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
	}

/**
 * Note: All create...() methods are not supported.  The specification
 * says nothing about what to do in this case.	Since some cannot throw
 * exceptions, this implementation returns null for each.
 */
	public Attr createAttribute(String name) throws DOMException {
		return null;
	}

	public Attr createAttributeNS(String namespaceURI, String localName) throws DOMException {
		return null;
	}

	public CDATASection createCDATASection(String data) throws DOMException {
		return null;
	}

	public Comment createComment(String data) {
		return null;
	}

	public DocumentFragment createDocumentFragment() {
		return null;
	}

	public Element createElement(String name) throws DOMException {
		return null;
	}

	public Element createElementNS(String namespaceURI, String localName) throws DOMException {
		return null;
	}

	public EntityReference createEntityReference(String name) throws DOMException {
		return null;
	}

	public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
		return null;
	}

	public Text createTextNode(String data) {
		return null;
	}

	public DocumentType getDoctype() {
		return null;
	}

	public Element getDocumentElement() {
		return mDocumentElement;
	}

	public String getDocumentURI() {
		return null;
	}

	public DOMConfiguration getDomConfig() {
		return null;
	}

	public Element getElementById(String elementId) {
		assert (mXFADoc  != null);
		ElementImpl result = null;
		com.adobe.xfa.Element xfaElement = mXFADoc.getElementByXMLId (elementId);
		if (xfaElement != null) {
			NodeImpl mappedNode = attachNode (xfaElement);
			assert (mappedNode != null);
			assert (mappedNode instanceof ElementImpl);
			result = (ElementImpl) mappedNode;
		}
//		debugReturn (elementId, result);
		return result;
	}

	public NodeList getElementsByTagName(String name) {
		assert (mDocumentElement != null);
		return mDocumentElement.getElementsByTagName (name);
	}

	public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
		assert (mDocumentElement != null);
		return mDocumentElement.getElementsByTagNameNS (namespaceURI, localName);
	}

	public DOMImplementation getImplementation() {
		return null;	// TODO: is this a legitimate return
	}

	public String getInputEncoding() {
		return null;
	}

	public boolean getStrictErrorChecking() {
		return false;
	}

	public String getXmlEncoding() {
		return null;
	}

	public boolean getXmlStandalone() {
		return false;
	}

	public String getXmlVersion() {
		return XML_VERSION;
	}

	public Node importNode(Node arg0, boolean arg1) throws DOMException {
		throw new DOMException (DOMException.NOT_SUPPORTED_ERR, "");
	}

	public boolean isDefaultNamespace(String namespaceURI) {
		assert (mDocumentElement != null);
		return mDocumentElement.isDefaultNamespace (namespaceURI);
	}

	public boolean isEqualNode(Node other) {
		if (this == other) {
			return true;
		}
		if (! super.isEqualNode (other)) {
			return false;
		}
		if (! (other instanceof DocumentImpl)) {
			return false;
		}
		return true;	// currently nothing to compare at doc level
	}

	public void normalizeDocument() {
		// TODO: OK to do nothing?
	}

	public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
		throw new DOMException (DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
	}

	public void setDocumentURI(String documentURI) {
		// TODO: OK to do nothing?
	}

	public void setStrictErrorChecking(boolean strictErrorChecking) {
	}

	public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
		// TODO: OK to do nothing?
	}

	public void setXmlVersion(String xmlVersion) throws DOMException {
		// TODO: OK to do nothing?
	}

	public String getNodeName() {
		return DOCUMENT_NODE_NAME;
	}

	public short getNodeType() {
		return DOCUMENT_NODE;
	}

	public String lookupNamespaceURI(String prefix) {
		String result = null;
		if (mDocumentElement != null) {
			result = mDocumentElement.lookupNamespaceURI (prefix);
		}
//		debugReturn1 ("lookupNamespaceURI", prefix, result);
		return result;
	}

	public String lookupPrefix(String namespaceURI) {
		String result = null;
		if (mDocumentElement != null) {
			result = mDocumentElement.lookupPrefix (namespaceURI);
		}
//		debugReturn1 ("lookupPrefix", namespaceURI, result);
		return result;
	}

	Node attach (com.adobe.xfa.Node xfaNode) {
		if (xfaNode instanceof com.adobe.xfa.Document) {
			return (xfaNode == mXFADoc) ? this : null;
		}
		return attachNode (xfaNode);
	}

	void setDocumentElement (ElementImpl documentElement) {
		assert (mDocumentElement == null);
		mDocumentElement = documentElement;
	}

	boolean testDefaultNamespace (String namespaceURI) {
		return false;	// default namespace cannot be set at the document level
	}

	private NodeImpl attachNode (com.adobe.xfa.Node xfaNode) {
		if (xfaNode instanceof com.adobe.xfa.Document) {
			assert (xfaNode == mXFADoc);
			return this;
		}

		com.adobe.xfa.Element xfaParent = getXFAParent (xfaNode);
		if (xfaParent == null) {
			return null;
		}
		NodeImpl parentNode = attachNode (xfaParent);
		if (parentNode == null) {
			return null;
		}
		assert (parentNode instanceof ParentNode);
		ParentNode parent = (ParentNode) parentNode;
		return parent.lookupXFAChild (xfaNode);
	}
}
