/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2009 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.dom;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Implements the W3C DOM NodeList interface.  It simply stores a list
 * of nodes.
 * @exclude from published api.
 */
class NodeListImpl implements NodeList {
	private final List<NodeImpl> mNodes;

	NodeListImpl (int initialCapacity) {
		mNodes = new ArrayList<NodeImpl> (initialCapacity);
	}

	public int getLength() {
		return mNodes.size();
	}

	public Node item (int index) {
		return ((0 <= index) && (index < mNodes.size())) ? mNodes.get (index) : null;
	}

	void addNode (NodeImpl node) {
		mNodes.add (node);
	}

	void addNodes (NodeImpl startNode) {
		while (startNode != null) {
			addNode (startNode);
			startNode = startNode.getNext();
		}
	}
}
