/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2009 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.dom;

import com.adobe.xfa.ut.StringUtils;

/**
 * Represents a qualified or unqualified.  This class is different from
 * java.namespace.QName in that it guarantees that all strings are
 * interned, including the fully qualified name.
 * @exclude from published api.
 */
final class QNameImpl {
	public static final String XMLNS = "xmlns";

	private final String mNamespace;
	private final String mPrefix;
	private final String mLocalName;
	private final String mQName;

	QNameImpl (String name) {
		mNamespace = null;
		mPrefix = null;
		mLocalName = name.intern();
		mQName = mLocalName;
	}

	QNameImpl (String namespace, String prefix, String localName) {
		mPrefix = StringUtils.isEmpty (prefix) ? null : prefix.intern();
		mLocalName = localName.intern();
		if (mPrefix == null) {
			mQName = mLocalName;
		} else {
			StringBuilder builder = new StringBuilder (prefix);
			builder.append (':');
			builder.append (localName);
			mQName = builder.toString().intern();
		}
		if (StringUtils.isEmpty (namespace)) {
			mNamespace = null;
		} else {
			mNamespace = namespace.intern();
		}
	}

	String getNamespace () {
		return mNamespace;
	}

	String getPrefix () {
		return mPrefix;
	}

	String getLocalName () {
		return mLocalName;
	}

	String getQName () {
		return mQName;
	}

// for debugging...
//	public String toString () {
//		StringBuilder builder = new StringBuilder();
//		if (! StringUtils.isEmpty (mNamespace)) {
//			builder.append ('{');
//			builder.append (mNamespace);
//			builder.append ('}');
//		}
//		builder.append (mLocalName);
//		return builder.toString();
//	}
}
