/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2009 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.dom;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/**
 * Implements the W3C DOM Text interface, wrapping an XFA DOM Chars instance.
 * @exclude from published api.
 */
class TextImpl extends CharacterDataImpl implements Text {

	TextImpl (ParentNode parent, com.adobe.xfa.Chars newTextNode) {
		super (parent, newTextNode, newTextNode.getData());
//		debugInit ("Text");
//		debug ("created");
	}

	public String getWholeText() {
		XFANodeHolder currentNode = this;
		for (;;) {
			XFANodeHolder prevNode = currentNode.forcePrev();
			if (prevNode == null) {
				break;
			}
			if (! isBenignNode (prevNode)) {
				break;
			}
			currentNode = prevNode;
		}

		StringBuilder textBuilder = new StringBuilder();
		while (currentNode != null) {
			if (! isBenignNode (currentNode)) {
				break;
			}
			if (currentNode instanceof TextImpl) {
				TextImpl textNode = (TextImpl) currentNode;
				textBuilder.append (textNode.getCharacterData());
			}
			currentNode = currentNode.forceNext();
		}
		return textBuilder.toString();
	}

	public boolean isElementContentWhitespace() {
		return false;
	}

	public boolean isEqualNode(Node other) {
		if (this == other) {
			return true;
		}
		if (! super.isEqualNode (other)) {
			return false;
		}
		if (! (other instanceof TextImpl)) {
			return false;
		}
		return true;	// currently nothing to compare for text
	}

	public Text replaceWholeText(String content) throws DOMException {
		throw new DOMException (DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
	}

	public Text splitText(int offset) throws DOMException {
		throw new DOMException (DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
	}

	public String getNodeName() {
		return TEXT_NODE_NAME;
	}

	public short getNodeType() {
		return TEXT_NODE;
	}

	private static boolean isBenignNode (NodeImpl node) {
		return (node instanceof TextImpl)
			|| (node instanceof CommentImpl)
			|| (node instanceof ProcessingInstructionImpl);
	}
}
