/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.Obj;
import com.adobe.xfa.Node;
import com.adobe.xfa.Element;
import com.adobe.xfa.ut.Peer;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.data.DataNode;


/**
 * @exclude from public api.
 */
public class FormListener extends Obj {
	
	private final FormModel	mFormModel;
	private final Element	mNode;
	private final Obj		mDependsOn;
	private final boolean	mbIsCalculate;

	
	public FormListener(
			FormModel formModel,
			Element node,
			Obj dependsOn,
			boolean bIsCalculate) {
		mFormModel = formModel;
		mNode = node;
		mDependsOn = dependsOn;
		mbIsCalculate = bIsCalculate;
		
		mNode.addPeer(this);
		mDependsOn.addPeer(this);
	}

	 public Node nodePtr() {
	 	return mNode;
	 }

	 public Obj dependsOnPtr() {
	 	return mDependsOn;
	 }

	 public boolean isCalculate() {
	 	return mbIsCalculate;
	 }

	 // overridden from Peer
	 
	 public void updateFromPeer(Object peerNode, 
	 							int eventType, 
	 							String arg1, 
	 							Object arg2) {
	 	// vantive 661887
	 	// queue up validations and calculations when the value changed 
	 	// or when we get an UPDATE notification (from layout, remerge...) 
	 	boolean bQueueScripts = (eventType == Peer.UPDATED  && !arg1.equals("Dirtied"));

	 	if (arg2 instanceof Content ||
	 		// watson 1306229, Should listen to data changes
	 		// also operations like save XML should add dependencies on all the
	 		// descendants as dependant if saveXML is called.
	 		peerNode instanceof DataNode ||
	 		peerNode instanceof DataModel)
	 		bQueueScripts = true;

	 	if (bQueueScripts)
	 		mFormModel.queueCalculatesAndValidates(mNode, true);
	 }

	 public void peerRemoved(Peer peer) {
	 	// our peer has been removed - go quiet. 
	 	// Eventually we'll be removed from the form model list.
	 	mute();
	 	deafen();
	 }

	/**
	 * @see Obj#getClassAtom()
	 */
	public String getClassAtom() {
		return "formListener";	// TODO: Should this be in STRS?
	}
	
	/**
	 * @see Obj#getClassName()
	 */
	public String getClassName() {
		return "formListener";
	}
}
