/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.formcalc;


import java.io.IOException;

import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.ResId;


/**
 * Class <b>CalcException</b> defines the exception objects used by the
 * {@link CalcParser} (FormCalc scripting engine).
 *
 * <p> Exception objects have but a single property: a 
 * {@link CalcSymbol}, which almost
 * invariably is of type CalcTypeError.  This architecture
 * permits the FormCalc scripting engine to propagate errors
 * easily up to the application, whenever errors are detected
 * in the intermediate stages of the evaluatation of a FormCalc
 * script.
 *
 * @author Mike P. Tardif
 *
 * @exclude from published api.
 */
public class CalcException extends RuntimeException {

	/*
	 * serialver-generated UID.
	 */
	private static final long serialVersionUID = -7820131771922187343L;

    private final transient CalcSymbol mSym;


    /**
     * Instantiates a CalcException object, whose
	 * CalcSymbol property is an object of type
	 * {@link CalcType} CalcTypeError.
     */
	CalcException() {
		/*
		 * Load "missing or illegal parameters." error message from resources.
		 */
		MsgFormat oErr = new MsgFormat(ResId.FC_ERR_PARAMETER);
		mSym = new CalcSymbol(oErr.toString(), true, 0, 0);
	}

    /**
     * Instantiates a CalcSymbol object, whose
	 * CalcSymbol property is an object of type
	 * {@link CalcType} CalcTypeError and value
	 * of the given error message string.
	 * @param sErr the error message string.
     */
	CalcException(String sErr) {
		mSym = new CalcSymbol(sErr, true, 0, 0);
	}

    /**
     * Instantiates a CalcException object, whose.
	 * CalcSymbol property is a copy of the given object.
	 * @param oSym the CalcParser object to be copied.
     */
	public CalcException(CalcSymbol oSym) {
		mSym = new CalcSymbol(oSym);
	}

    /**
     * Gets this object's CalcSymbol.
     */
	CalcSymbol getSymbol() {
		return mSym;
	}
	
    /**
     * This class is not really serializable, so prevent attempts to serialize from succeeding.
     */
	private void writeObject(java.io.ObjectOutputStream out) throws IOException {
		throw new java.io.NotSerializableException(getClass().getSimpleName());
	}
}