/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.formcalc;


/**
 * Class <b>DisplayHost</b> defines the interface by which the
 * {@link CalcParser} (FormCalc scripting engine)
 * can display message boxes in
 * some display host, in response to a MessageBox calc.
 *
 * <p> In environments where this is possible and desired,
 * applications will need to inform the FormCalc script engine
 * that they are capable of supporting the DisplayHost
 * interface by invoking the 
 * {@link CalcParser#setDisplayHost(DisplayHost)}
 * method. 
 *
 * <p> Environments that are not able to display message boxes
 * need not define nor install a DisplayHost objects.
 * Any MessageBox calc encountered by the FormCalc script engine
 * will automatically return -1.
 *
 * @author Mike P. Tardif
 * 
 * @exclude from published api.
 */
public interface DisplayHost {

    /**
     * Abstract method to display a modal message box dialog on some display
	 * host.
     * 
	 * @param nValue - the kind of message box command buttons to display
	 * in the message box.  Possible values are:
	 * <blockquote>
	 * <dl>
	 * <dt> 0 <dd> OK button only.</dd></dt>
	 * <dt> 1 <dd> OK and Cancel buttons.</dd></dt>
	 * <dt> 2 <dd> Abort, Retry, and Ignore buttons.</dd></dt>
	 * <dt> 3 <dd> Yes, No, and Cancel buttons.</dd></dt>
	 * <dt> 4 <dd> Yes, and No buttons.</dd></dt>
	 * <dt> 5 <dd> Retry, and Cancel buttons.</dd></dt>
	 * </dl>
	 * </blockquote>
	 * @param sMessage the text to display in the message box.
	 * @param sTitle the title to display on the message box.  If empty,
	 * some system derived title will be used instead.
	 * @return one of the following numeric values corresponding
	 * to the command button selected in the message box, or, -1 if the
	 * message box could be displayed:
	 * <blockquote>
	 * <dl>
	 * <dt> 1 <dd> for ok responses.</dd></dt>
	 * <dt> 2 <dd> for cancel responses.</dd></dt>
	 * <dt> 3 <dd> for abort responses.</dd></dt>
	 * <dt> 4 <dd> for retry responses.</dd></dt>
	 * <dt> 5 <dd> for ignore responses.</dd></dt>
	 * <dt> 6 <dd> for yes responses.</dd></dt>
	 * <dt> 7 <dd> for no responses.</dd></dt>
	 * </dl>
	 * </blockquote>
     */
    int messageBox(int nValue, String sMessage, String sTitle);

}
