package com.adobe.xfa.gfx;

/**
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public class GFXDecorationInfo {
//	 Decoration codes: low four bits are type (unknown, none, all or word).
//	 High four bits are style (single, double, strikeout).	Use bit-wise OR.
	public final static int DECORATE_TYPE = 0x0F;
	public final static int DECORATE_UNKNOWN = 0x00;
	public final static int DECORATE_NONE = 0x01;
	public final static int DECORATE_ALL = 0x02;
	public final static int DECORATE_WORD = 0x03;

	public final static int DECORATE_COUNT = 0xF0;
	public final static int DECORATE_SINGLE = 0x10;
	public final static int DECORATE_DOUBLE = 0x20;

	public final static GFXDecorationInfo decorateNone = new GFXDecorationInfo (0, DECORATE_NONE);
	public final static GFXDecorationInfo decorateSingleWord = new GFXDecorationInfo (1, DECORATE_WORD);
	public final static GFXDecorationInfo decorateSingleAll = new GFXDecorationInfo (1, DECORATE_ALL);
	public final static GFXDecorationInfo decorateDoubleWord = new GFXDecorationInfo (2, DECORATE_WORD);
	public final static GFXDecorationInfo decorateDoubleAll = new GFXDecorationInfo (2, DECORATE_ALL);

	public final int mType;
	public final int mCount;

	public GFXDecorationInfo (int count, int type) {
		mType = type;
		mCount = count;
	}

/**
 * Extract text decoration into usable values.
 * <p>
 * Given an underline, line-through or overline value, extract the two
 * component values from it for further processing.
 * @param nDecoration Input text decoration value.
 * @return TRUE if there is any decoration; FALSE if no decoration.
 */
	public static GFXDecorationInfo extractDecoration (int nDecoration) {
		int nType = nDecoration & DECORATE_TYPE;
		int nCount = 0;

		switch (nDecoration & DECORATE_COUNT) {
			case DECORATE_SINGLE:
				nCount = 1;
				break;
			case DECORATE_DOUBLE:
				nCount = 2;
				break;
		}
		if ((nType == DECORATE_NONE) || (nCount == 0)) {
			return decorateNone;
		}

		if (nCount == 1) {
			return (nType == DECORATE_WORD) ? decorateSingleWord : decorateSingleAll;
		} else {
			return (nType == DECORATE_WORD) ? decorateDoubleWord : decorateDoubleAll;
		}
	}
}
