/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.layout;


import com.adobe.xfa.font.FontService;
import com.adobe.xfa.service.Service;
import com.adobe.xfa.service.href.HrefService;
import com.adobe.xfa.form.FormInstanceManager;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Node;
//import com.adobe.xfa.NodeList;
//import com.adobe.ut.SortedArray;
//import com.adobe.ut.Storage;


/**
 * This object represents a high level transformation that acts on a given FormModel 
 * to provide layout functionality within Acrobat plugin. This includes things like 
 * listening for template/data/form changes, hit-testing , incremental relayout etc.
 * <p>
 * Like the other xfalayout structures, the AcroFormLayout object encapsulates the following information:
 * i) what type of object to render (form node)
 * ii) what page the object resides
 * iii) object's (x,y) position on a given page 
 * iv) interactive properties pertaining to whether node has changed
 * It does so by storing an array of node trees, with each tree representing 
 * the layout of a new page. 
 * However unlike it's parent class xfaformlayout the xfaacroformlayout trees are comprised of AcroFormLayoutNode objects.
 * These nodes contain the extra information needed for functionlity specific to incremental relayout
 * within the Acrobat 7 xfa plugin, something that conventional form layout cannot do.
 *
 * @exclude from published api.
 */
public class AcroFormLayout extends FormLayout implements FormInstanceManager.InstanceListener {

	public AcroFormLayout(FontService oFontService, /*Image*/Service oImageService, HrefService oHrefService, AppModel oAppModel) {
		super(oAppModel);
		mbUnrepairable = false;
		mbUseLayoutNodePool = true;
		mnNextNodeID = 0;

		assert(oFontService != null);
		assert(oImageService != null);
		assert(oHrefService != null);

	// JavaPort: TODO
		//Note: tweaking this number may increase performance
	//	moLayoutNodePool.extendSize(64); 
	//	AcroformLayoutEnv oEnv = new AcroformLayoutEnv(oFontService, oImageService, oHrefService, getLayoutDriver());
	//	getTextResolver()->registerTextResolver(poEnv);
	//	getTextResolver()->setLayout(this);
	//	super.setLayoutEnv(oEnv);
	}

//	/**
//	 * Returns true if the any aspect of the layout is currently damaged
//	 * and false otherwise.
//	 */
//	public boolean isLayoutDamaged();
	
//	/**
//	 * Return true if any portion of the layout is considered
//	 * render damaged, that is, requires it's visual representation
//	 * updated.
//	 */
//	public boolean isRenderDamaged();

//	/**
//	 * Return true if any portion of a given page of layout is considered
//	 * render damaged, that is, requires it's visual representation
//	 * updated.
//	 * @param nPage zero based index of page to check for render damage.
//	 */
//	public boolean isRenderDamaged(int nPage);

//	/**
//	 * Clears all render damage 
//	 */
//	public void clearRenderDamage();

//	/**
//	 * Clears all render damage for given page
//	 */
//	public void clearRenderDamage(int nPage);

	/** 
	 * Make this layout unrepairable by incremental relayout.
	 * Called by layout damage listening code to avoid
	 * futile attempts. 
	 */
	public void setUnrepairable() {
		mbUnrepairable = true;	
	}

	/**
	 * Return true if this layout is not incrementally repairable
	 */
	public boolean isUnrepairable() {
		return mbUnrepairable;
	}

//	/**
//	 * Called by xfaacroformlayout nodes to determine whether
//	 * they can ignore peer damage notifications.
//	 */
//	public boolean ignoreDamage();

//	/**
//	 * Called by the application to tell layout to 
//	 * ignore any peer damage notifications.
//	 */
//	public void setIgnoreDamage(boolean bIgnore) {
//		mbIgnoreDamage = bIgnore;
//	}

//	/**
//	 * Utility function that determines whether a proxy layout may be used for given node.
//	 * This means layout for this object will use a placeholder and postponed until a later time.
//	 * This function may be promoted to base interface when all layouts may use this mechanism.
//	 */
//	public boolean isLayoutProxyable(Node oNode);

//
//Removed node ids
//
//	public Storage<int> getRemovedNodeIds();	
//	public void clearRemovedNodeIds();
//	public void addRemovedNodeId(int nId);

//
//Generate new ids, used during node creation
//
	public int newID() {
		mnNextNodeID++;
		return mnNextNodeID;
	}


//
//Layout node pooling. In general should not be called by external classes.
//Node pooling is on 99% of the time and is only meant to be toggled internally. 
//There are a few exceptions, like for debugging/performance work/XTG designer, thus a public API is provided.
//
	public void enableLayoutNodePooling(boolean bEnable) {
		mbUseLayoutNodePool = bEnable;
	}

	public boolean enableLayoutNodePooling() {
		return mbUseLayoutNodePool;
	}

//Enable/disable box model proxies,
//	public void enableProxyBoxModels(boolean bEnable);
//	public boolean enableProxyBoxModels();
//	public void resolveAllProxyBoxModels();
//	public void resolveAllProxyBoxModels(int nPage);
//	public void resolveAllProxyBoxModels(AcroFormLayoutNode oNode);

// Retrieve AcroformLayout node by ID
//	public AcroFormLayoutNode getLayoutNode(int nID);
//	public AcroFormLayoutNode getLayoutNode(AcroFormLayoutNode oLayoutNode, int nID);

//Layout overrides
//	/**
//	 * Create a new LayoutNodeNode around a given Node.
//	 * @param oNode xfanode for which this layout node applies
//	 * @return an LayoutNode.
//	 * Node returned is orphaned, i.e. not a member of
//	 * any page hierarchy.
//	 */
//	public LayoutNode createNode(Node oNode);
//	public LayoutNode createNode(Node oNode, BoxModelLayout oBoxModel);

//	/**
//	 * Create and return the entire layout subhierarchy for a given node.
//	 * This returned layout tree represents the layout oNode and all it's children.
//	 * This is to provide an opportunity for xfalayouts to shortcut the regular layout building for this xfanode.
//	 * In many instances AcroFormLayout records a pool of reusable layout node subhierarchies that
//	 * it can return to shortcut having to retraverse and recreate the layout for that xfanode.
//	 */
//	public LayoutNode createLayoutTree(Node oNode);	

//Layout overrides
//	/**
//	 * Notify the layout of a node that is relevant to layout
//	 * but is not directly present within the layout itself.
//	 * Such nodes are referred to as 'anonymous'
//	 * i.e. xfa nodes that don't have corresponding layout nodes
//	 * such as subformSets, pageSets.
//	 */
//	public void notifyAnonymousNode(Node oNode);
	
	
//	/**
//	 * Notify the acroformlayout of a node that is deemed irrelevant
//	 * with respect to layout and it's not anonymous or hidden.
//	 * Acroformlayout will attach a listener to any instancemanager
//	 * nodes so it can be informed when subforms are being added/removed/moved
//	 * since this is likely one of the most commonly done things in the context
//	 * of a plugin.
//	 */
//	 public void notifyIgnoredNode(Node oNode);

//	 /**
//	 * Notify the layout of a hidden node - hidden nodes are usually not
//	 * present within layout. This function can be overriden to perform 
//	 * some special processing unique to a specific layout.
//	 */
//	public void notifyHiddenNode(Node oNode);


//	/**
//	 * Notify the layout of an embedded object and the container it is to be embedded in.
//	 */
//	 public void notifyEmbeddedObject(Node oEmbedContainer, Node oDependsOn);
	
//	/**
//	 * Reset the layout
//	 * The layout is empty upon return (no pages)
//	 * This function allows the optional exception of any pooled resources that may be 
//	 * useful for a subsequent layout pass, ie between a failed incremental attempt
//	 * in preparation for a full layout. 
//	 * @param bClearPooledResources boolean to indicate whether to also reset any pooled resources
//	 * In general external classes should use reset() or reset(true)
//	 */
//	 public void reset(boolean bClearPooledResources /* = true */);

//InstanceListener interface

    public void preAddInstance() {
        // JavaPort: TODO Auto-generated method stub
    }

    public void preRemoveInstance(Node toBeRemoved) {
        // JavaPort: TODO Auto-generated method stub
    }

    public void preMoveInstance(Node toBeMoved) {
        // JavaPort: TODO Auto-generated method stub
    }

    public void postAddInstance(Node wasAdded) {
        // JavaPort: TODO Auto-generated method stub
    }

    public void postRemoveInstance(Node wasRemoved) {
        // JavaPort: TODO Auto-generated method stub
    }

    public void postMoveInstance(Node wasMoved) {
        // JavaPort: TODO Auto-generated method stub
    }

//	/**
//	 * Indicate whether this object supports incremental relayout
//	 */
//	protected boolean supportsIncrementalLayout();

//	/**
//	 * Kick off an incremental layout
//	 * @return true if incremental layout was successfully completed
//	 * and false otherwise.
//	 * Failure in incremental relayout causes a full layout pass to occur
//	 */
//	protected boolean incrementalLayout();

//	/**
//	 * Called before an incremental layout is about to proceed.
//	 * @return true if incremental layout is to proceed and false
//	 * otherwise
//	 */
//	protected boolean preIncrementalLayout();	
	
//	/**
//	 * Called after an incremental layout has been attempted.
//	 * @param bIncrPassed true if the incremental layout was completed successfully, false
//	 * otherwise.
//	 */
//	protected void postIncrementalLayout(boolean bIncrementalLayoutPassed);
	
//	/**
//	 * Called after a successful full layout
//	 * has finished
//	 */
//	protected void postFullLayout();	

//	/**
//	 * Allow a layout object to perform any operations that need to occur after
//	 * a layout has completed.
//	 */
//	protected void postLayout();

//	/**
//	 * Repair any damged layout nodes that occurred from $layout:ready scripts
//	 * and on fields/draws
//	 * Only called if some script fires that changes the Form DOM post $layout:ready.
//	 */
//	protected void repairLayoutReadyDamage();
	
//private functions
//	private void repairLayoutReadyDamage(AcroFormLayoutNode oNode);
		
//	private boolean repairPageBackground(int nPage);
//	private boolean repairPageContent(int nPage);

//	private boolean isPoolableLayoutSubtree(AcroFormLayoutNode oNode);
//	private boolean isPoolableLayoutNode(AcroFormLayoutNode oNode);
//	private boolean isPoolableLayoutNode(AcroFormLayoutNodeImpl poLayoutNodeImpl);
//	private AcroFormLayoutNode lookupPooledLayoutNode(Node oNode);
//	private void poolLayoutNodes(AcroFormLayoutNode oNode);
//	private void clearLayoutNodePool();

//	private boolean addInstances();
//	private boolean removeInstance(Node oNode);
//	private boolean moveInstances();
	
	//functions to determine where a node would exist within the layout.	
//	private boolean	findLayoutPosition(Node oNodeToInsert, AcroFormLayoutNodeImpl poInsertParent, AcroFormLayoutNodeImpl poInsertBeforeChild);
//	private void getChildLayoutOrder(Node oNode, NodeList oList);
	
//	private void recursiveSetFullRenderDamage(AcroFormLayoutNodeImpl poNode);
//	private void recursiveSetRenameRenderDamage(AcroFormLayoutNodeImpl poNode);

	//Listener to associate with hidden nodes so that damage is still heard.
	//It can be queried as to whether any hidden nodes 
//	private LayoutHiddenObjPeer moHiddenObjPeer;

	//Listener to associate with SubformSet nodes so that damage is still heard. 
//	private LayoutSubformSetObjPeer moSubformSetObjPeer;

	//Listener to associate with embedded objects (aka floating fields) so that damage is still heard. 
//	private LayoutEmbeddedObjPeer moEmbeddedObjPeer;
	
	//shortcut flag whether an incremental relayout is even possible
	private boolean mbUnrepairable;

//Node pooling
	//flag whether to pool reusable layout nodes for the next layout pass. 99% of the time this flag is true
	//and is only meant to be toggled internally. There are a few exceptions, like for debugging, so there is a public
	//API to switch this
	private boolean mbUseLayoutNodePool;	
	//flag whether any pooled nodes were actually reused
//  private boolean mbPooledNodesReused = false;
	//list of those layout nodes that we may be able to reuse (instead of regenerate) during the next layout pass
//	private SortedArray<Node, AcroFormLayoutNode> moLayoutNodePool;
	
	//state flags so we can ignore peer notifications during these three common operations.
//  private boolean mbAddingInstance = false;
//  private boolean mbRemovingInstance = false;
//  private boolean mbMovingInstance = false;
//  private boolean mbIgnoreDamage = false;
//  private boolean mbRemovedInstance = false;

//	private NodeList moAddedNodes;
	
//The following are data structures used to record render damage
			
	//List of ids for nodes that were removed (one list per page)
//	private Storage<int> moRemovedNodeIds;

	//Counter for the next available node id. This accumulates over
	//the lifetime of the acroformlayout.
	private int	mnNextNodeID;
//  private boolean	mbDelete = false;

//Box model proxy flag. This allows proxy boxmodels to be used when possible, postponing
//heavy lifting of text formatting until later.
//  private boolean mbAllowLayoutProxyBM = true;

//hide these
//	private AcroFormLayout();
//	private AcroFormLayout(AcroFormLayout oObj);
}
