/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.layout;


import com.adobe.xfa.Model;
import com.adobe.xfa.font.FontService;
import com.adobe.xfa.gfx.GFXEnv;
import com.adobe.xfa.gfx.GFXDriver;
import com.adobe.xfa.service.Service;
import com.adobe.xfa.service.href.HrefService;
import com.adobe.xfa.text.TextContext;
import com.adobe.xfa.text.TextDisplay;
import com.adobe.xfa.text.TextResolver;
import com.adobe.xfa.ut.Angle;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.ResId;


/**
 * A superclass of GFXEnv used by the layout package.
 */
public class LayoutEnv extends GFXEnv {

	/**
	 * Instantiates a default layout environment.
	 */
	public LayoutEnv() {
		//
		// Javaport: added for Gibson, avoiding the need to 
		// do publish ForntService, ImageService, HrefService
		// and LayoutDriver classes.
		//
		this(null, null, null, new LayoutDriver());
	}

	/**
	 * Hidden constructor.
	 *
	 * @exclude from published api.
	 */
	protected LayoutEnv(LayoutEnv oSource) {
	}

	/**
	 * Instantiates a <code>LayoutEnv</code> from the given
	 * arguments.
	 *
	 * @param oFontService a font service.
	 * @param oImageService an image service.
	 * @param oHrefService an href service.
	 * @param oDriver a layout driver.
	 *
	 * @exclude from published api.
	 */
	public LayoutEnv(FontService oFontService,
						/*Image*/Service oImageService,
						HrefService oHrefService,
						LayoutDriver oDriver) {
		moLayoutDriver = oDriver;
//		moImageService = oImageService;
		moHrefService = (HrefService) oHrefService;
		moFontService = (FontService) oFontService;
		moLayoutHandler = null;
//		mpGfxAttrPool = null;
//		mpGfxFontMapper = null;
		moTextResolver = null;
//		moBarcodeResolver = null;
//		moPageSizeResolver = null;
		moTextContext = null;
		moTextContext = new TextContext();	// creates with a ref count of 1
//		assert(null != oFontService);
//		assert(null != moImageService);
//		assert(null != moHrefService);
		assert(null != oDriver);

		fontService(moFontService);

		//*sigh* order matters here. It would seem that the
		//driver needs to be set before the pool/mapper
		moLayoutDriver.setLayoutEnv(this);

// Javaport: TODO
//		mpGfxAttrPool = new GFXAttrPool();
//		mpGfxAttrPool.env(this);
//		mpGfxFontMapper = new GFXFontMapper(mpGfxAttrPool);
//		mpGfxFontMapper.Env(this);
	}

	/**
	 * Sets the layout handler that processes output from the layout.
	 * @param pHandler the object to redirect the draw responsibilities to.
	 *
	 * @exclude from published api.
	 */
	public void layoutHandler(LayoutHandler pHandler) {
		moLayoutHandler = pHandler;
	}

	/**
	 * Gets the layout handler that processes output from the layout.
	 * @return LayoutHandler, the object to redirect
	 * the draw responsibilities to.
	 *
	 * @exclude from published api.
	 */
	public LayoutHandler layoutHandler() {
		return moLayoutHandler;
	}

// Javaport: TODO
//	 /**
//	 * Gets the ImageService that will resolve Image content for fields
//	 * and draws based on their content.  It will load images and provide
//	 * accessors to the required image information.
//	 * @return the ImageService to resolve images with.
//	 *
//	 * @exclude from published api.
//	 */
//	public ImageService getImageService() {
//		return moImageService;
//	}

	 /**
	 * Gets the HrefService that will resolve href content for protoable
	 * node based on their content.  It will load href urls and provide
	 * accessors to the required href information.
	 * @return the HrefService to resolve hrefs with.
	 *
	 * @exclude from published api.
	 */
	public HrefService getHrefService() {
		return moHrefService;
	}

// Javaport: TODO
//	/**
//	 * Gets the BarcodeResolver that will resolve a given barcode. It allows
//	 * to know which barcode are supported and/or native
//	 * @return the BarcodeResolver to resolve barcodes with.
//	 *
//	 * @exclude from published api.
//	 */
//	public BarcodeResolver getBarcodeResolver() {
//		return moBarcodeResolver;
//	}

	/**
	 * Sets the font service to be used with this layout env. 
	 *
	 * @exclude from published api.
	 */
	public void setFontService(FontService oFontService) {
		moFontService = oFontService;
		fontService(oFontService);
	}

	/**
	 * Gets the font service to be used with this layout env. 
	 *
	 * @exclude from published api.
	 */
	public FontService getFontService() {
		return moFontService;
	}

// Javaport: TODO
//	/**
//	 * Sets the BarcodeResolver that will resolve a given barcode.
//	 *
//	 * @exclude from published api.
//	 */
//	public void setBarcodeResolver(BarcodeResolver oBarcodeResolver) {
//		moBarcodeResolver = oBarcodeResolver;
//	}

	/**
	 * Sets the driver, returning previous
	 *
	 * @exclude from published api.
	 */
	public LayoutDriver setDriver(LayoutDriver oDriver) {
		LayoutDriver oOldDriver = moLayoutDriver;
		moLayoutDriver = oDriver;
		return oOldDriver;
	}

// Javaport: TODO
//	/**
//	 * Gets the PageMediumResolver that will resolve a given pageArea size. 
//	 *
//	 * @exclude from published api.
//	 */
//	public PageMediumResolver getPageMediumResolver() {
//		return moPageSizeResolver;
//	}

// Javaport: TODO
//	/**
//	 * Sets the PageMediumResolver that will resolve a given barcode.
//	 *
//	 * @exclude from published api.
//	 */
//	public void setPageMediumResolver(PageMediumResolver oPageResolver) {
//		moPageSizeResolver = oPageResolver;
//	}

	/**
	 * Gets the text context.
	 * The text context is an opaque AXTE object that allows the layout of
	 * multiple text to share a number of serially-reusable objects.  These
	 * objects are expensive to create.   layout code uses this common
	 * text context object when creating text objects, in order to effect
	 * that sharing.
	 * @return The text context object.
	 *
	 * @exclude from published api.
	 */
	public TextContext getTextContext() {
		return moTextContext;
	}

	/**
	 * Sets the model.  We will use this for creating new  nodes.
	 * @param oModel a model.
	 *
	 * @exclude from published api.
	 */
	public void setModel(Model oModel) {
		moModel = oModel;
	}

	/**
	 * Gets the model.  We will use this for creating new  nodes.
	 * @return a model.
	 *
	 * @exclude from published api.
	 */
	public Model getModel() {
		return moModel;
	}

// Javaport: TODO
//	/**
//	 * Gets the gfx attribute pool.
//	 *
//	 * @exclude from published api.
//	 */
//	public GFXAttrPool getGfxAttrPool() {
//		return mpGfxAttrPool;
//	}

// Javaport: TODO	 
//	/**
//	 * Gets the gfx font mapper object.
//	 *
//	 * @exclude from published api.
//	 */
//	public GFXFontMapper getGfxFontMapper() {
//		return mpGfxFontMapper;
//	}
	
	/**
	 * Sets the text resolver interface - acts as callback
	 * for xfa:embed references
	 *
	 * @exclude from published api.
	 */
	public void setTextResolver(TextResolver pResolver) {
		assert(null != pResolver);
		moTextResolver = pResolver;
	}

	/**
	 * Gets the text resolver interface - acts as callback for
	 * xfa:embed references
	 *
	 * @exclude from published api.
	 */
	 public TextResolver getTextResolver() {
		return moTextResolver;
	}
	 
	 /**
	 * Gets the LayoutDriver associated with
	 * this environment.
	 * @return a LayoutDriver.
	 *
	 * @exclude from published api.
	 */
	public LayoutDriver getLayoutDriver() {
		return moLayoutDriver;
	}

	//
	// Derived from GFXEnv.
	//

	/**
	 * Gets meta file data.
	 *
	 * @exclude from published api.
	 */
	public int getMetaFileData(byte[] pClipData, int size, Rect oDrawArea) {
		throw new ExFull(ResId.UNSUPPORTED_OPERATION, "LayoutEnv#getMetaFileData");
	}

	/**
	 * sets the clipping rectangle.
	 *
	 * @exclude from published api.
	 */
	public void setClipRect(Rect oRect) {
		moLayoutDriver.setClipRect(oRect);
	}

	//
	// proprietary: (for use by impl classes to display text)
	//

	/**
	 * @exclude from published api.
	 */
	public boolean renderText(LayoutHandler oLayoutHandler,
					TextDisplay oDisplay,
					CoordPair oOffset,
					boolean	bWrap,
					boolean	bTruncate,
					Rect oInvalidatedRect /* = Rect.ZERO */) {
		return renderText(oLayoutHandler, oDisplay, oOffset, bWrap, bTruncate, Angle.ZERO, oInvalidatedRect);
	}

	/**
	 * @exclude from published api.
	 */
	public boolean renderText(LayoutHandler oLayoutHandler,
					TextDisplay oDisplay,
					CoordPair oOffset,
					boolean	bWrap,					// TBD: use this parameter
					boolean	bTruncate,
					Angle oAngle,
					Rect oInvalidatedRect /* = Rect.ZERO */) {
		boolean bTextFits = false;
		if (oDisplay == null || null == moLayoutDriver)
			return bTextFits;
		moLayoutHandler = oLayoutHandler;
		GFXDriver oDriver = driverAttach();	// must attach for offset management
		assert(oDriver == moLayoutDriver);
		GFXEnv oEnv = this;				// upcast for deleter to compile
		try {
			moLayoutDriver.pushOffset(true, oOffset);
			moLayoutDriver.pushAngle(true, oAngle, false, oOffset);
		// Javaport: TODO
		//	bTextFits = oDisplay.GFXDraw(this, ! bWrap, null, TextPrefOpt.OPT_LINE, bTruncate, oInvalidatedRect);
			moLayoutHandler = null;
		}
		finally {
			oEnv.driverDetach();
			oDriver.popOffset();
			oDriver.popAngle();
		}
		return bTextFits;
	}


	/**
	 * Return back the to the driver associated with
	 * this Environment.
	 * @return a GFXDriver.
	 *
	 * @exclude from published api.
	 */
	protected GFXDriver driver() {
		return moLayoutDriver;
	}

//	private ImageService	moImageService;		// resolve  Images
	private HrefService		moHrefService;		// resolve  Hrefs
	private FontService		moFontService;		// resolve font references
	private Model			moModel;			// an Model to create nodes with
	private LayoutHandler 	moLayoutHandler;	// target for layout graphic output
	private LayoutDriver	moLayoutDriver;		// the graphics driver
//	private GFXAttrPool		mpGfxAttrPool;		// shared attribute pool
//	private GFXFontMapper	mpGfxFontMapper;	// shared font mapper
//	private BarcodeResolver moBarcodeResolver;
//	private PageMediumResolver moPageSizeResolver; //resolves page sizes
	private TextResolver 	moTextResolver;		//callback for resolving embedded text references
	private TextContext 	moTextContext;

}
