/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.layout;


import com.adobe.xfa.Element;


/**
 * A node component of the layout transformation hierarchy. 
 * It represents a new frame of reference and is internally organized using the
 * box model paradigm.
 *
 * Instances of the LayoutNode class are assembled in parent/child relationships
 * and is associated with a form node.
 * Each instance represent a frame of reference that applies a coordinate space
 * transformation to it's xfa node as well as any child layout nodes.
 *
 * Layout nodes may sometimes daisy-chained together (linked list) through getNextExistence()/getPRevExistence.
 * Note that is completely separate from it's parent/child relationships in the layout hierarchy.
 * Rather an existence represents a piece of a laid out xfa container. For instance, a field gets split across 4 pages as 4
 * different pieces. Each piece, or existence is represented by a different layout node and each of these 4 layout nodes is 
 * connected to the previous and next existence. The first piece will return a null 'previous' existence and the last piece has 
 * returns a null 'next' existence
 *
 * Coordinate conversions: model vs layout
 * APIs are provided to convert between coordinates in model space to layout space and vice versa.
 * Consider an object, i.e. a field that is defined in that template as 15in high. Assume when paginated this field
 * is split across 3 pages, each piece being 5in high. Model space is that of the contiguous, unsplit 15in high field.
 * Model-content/model-caption space simply refers to the contiguous unsplit content/caption subregions of the model space.
 * Layout space is local coordinate space of any one of the three layout nodes that represents a piece of the model field.
 * Layout-content/layout-caption space refers to the content/caption subregions of the layoutnode space.
 * Example:
 * The model coordinate (0,7.5in) represents a point exactly halfway down the field. So
 * x=0 y=7.5in Model space ---&gt; x=0, y=2.5in of the second layout node (middle piece) for this field.
 * The layout coordinate (0,0) relative of the third layout node (last piece) represents the top left of that layout node. So
 * x=0 y=0 of Layoutnode[2] ----&gt; x=0 y=10in model space
 *
 * @exclude from published api.
 */
public class LayoutNode extends Element { 

    protected Element moFormComponent;

    public LayoutNode(Element oFormModelNode) {
        moFormComponent = oFormModelNode;
    }

    /**
     * Principle Constructor - initialize given a box model layout
     */
    public LayoutNode(Element oFormModelNode, BoxModelLayout oBoxModel) {
        moFormComponent = oFormModelNode;
    }

    /**
     * getFormNode.
     * Return the form node associated with this layout node.
     */
    public Element getFormNode() {
        return moFormComponent;
    }

//  /**
//   * isPageAreaBackground
//   * @returns true if this layout node represents an object that
//   * exists on the pageArea background and false otherwise.
//   * Page background is considered any object 
//   * are not considered page background.
//   * In terms of xfa syntax, page background is defined
//   * in container child elements of <pre><pageArea></pre> 
//   */
//  public boolean isPageAreaBackground();

//  /**
//   * isRootSubform.
//   * @returns true if this layout node is associated
//   * with the root subform and false otherwise
//   */
//   public boolean isRootSubform();

//   /**
//    * isTableCell.
//    * @returns true if this layout node represents a table cell
//    * and false otherwise
//    */
//  public boolean isTableCell();

//  /**
//   * isTableRow.
//   * @returns true if this layout node represents a table row and false otherwise
//   */
//  public boolean isTableRow();

//   /**
//    * getRootSubform.
//    * Searches up the current layout hierarchy to find the ancestor
//    * node associated with the root subform
//    * @return The layout node ancestor associated with the root subform
//    */
//   public LayoutNode getRootSubform();

//   /**
//    * getPage.
//    * Searches up the current layout hierarchy to find the ancestor
//    * node that represents the current page.
//    * @return The layout node ancestor associated with the page
//    */
//   public LayoutNode getPage();

//    /**
//    * getContentArea.
//    * Searches up the current layout hierarchy to find the ancestor
//    * node that represents the current contentArea.
//    * @return The layout node ancestor associated with the contentArea
//    */
//   public LayoutNode getContentArea();

//  /**
//   * Return true if this node has layout damage of ANY kind
//   * and false otherwise.
//   * @param bSearchSubTree  true to search subhierarchy under
//   * this node for layout damage.
//   * Pass in true to see if this node and any node under
//   * it is currently layout damaged. Pass in false to query determine
//   * damage on this node only.
//   */
//  public boolean isLayoutDamaged(boolean bSearchSubTree /* = false */);

//  /**
//   * Return true if this node is repairable
//   * and false otherwise.
//   * @param bSearchSubTree  true to search subhierarchy under
//   * this node for layout damage.
//   * Pass in true to see if this node and any node under
//   * it is currently repairable. Pass in false to query determine
//   * repairability on this node only.
//   */
//  public boolean isLayoutRepairable(boolean bSearchSubTree /* = false */);

//  /**
//   * Clear all damage.
//   * @param bClearSubTree true to clear layout damage on all nodes in subhierarchy
//   * false will clear layout damage on this node only.
//   */
//  public void clearLayoutDamage(boolean bClearSubTree /* = false */);


//  /**
//   * Offset routines.
//   */
//  public void initOffset();

//  public void Offset(CoordPair oOffset);
//  public CoordPair Offset();
//  public void OffsetX(UnitSpan oX);
//  public void OffsetY(UnitSpan oY);
//  public UnitSpan OffsetX();
//  public UnitSpan OffsetY();

//  /**
//   * Absolute offset.
//   */
//  public CoordPair AbsoluteOffset();
//  public UnitSpan  AbsoluteOffsetX();
//  public UnitSpan  AbsoluteOffsetY();

//  /**
//   * Box model extent routines.
//   */    
//  public Rect getNominalExtent(boolean bTranslate /* = false */);
//  public Rect getVisualExtent(boolean bTranslate /* = false */);
//  public Rect getBorderExtent(boolean bTranslate /* = false */);
//  public Rect getContentBorderExtent(boolean bTranslate /* = false */);
//  public Rect getCaptionExtent(boolean bTranslate /* = false */);
//  public Rect getContentExtent(boolean bTranslate /* = false */);


//  /**
//   * getBoxModel.
//   * Return the box model layout for the  Form 
//   * object that's associated with this layout node.
//   */
//  public BoxModelLayout getBoxModel();

//  /**
//   * Adds oNode to the linked list of nodes
//   * representing a chain of existence for
//   * a template object.
//   */
//   public void addExistence(LayoutNode oNode);
//   
//   /**
//    * Removes this layout node from the linked list of nodes
//    * representing a chain of existence for a template object.
//    */
//   public void removeExistence();


//  /**
//   * Returns true if there is a next
//   * layout node in the chain of existence
//   * and false otherwise.
//   */
//   public boolean hasNextExistence();

//  /**
//   * Returns true if there is a previous
//   * layout node in the chain of existence
//   * and false otherwise.
//   */
//  public boolean hasPrevExistence();

//  /**
//   * Returns the next layout node in the chain of existence
//   * and null otherwise.
//   */
//  public LayoutNode getNextExistence();

//  /**
//   * Returns the next layout node in the chain of existence
//   * and null otherwise.
//   */
//  public LayoutNode getPrevExistence();

//  /**
//   * Return the first existence in the chain.
//   */ 
//  public LayoutNode getFirstExistence();

//  /**
//   * Return the last existence in the chain.
//   */ 
//  public LayoutNode getLastExistence();

//  /**
//   * Return if this node has a render proxy box model.
//   */
//  public boolean isRenderProxy();

//  /**
//   * Remove the underlying RenderProxy box model and
//   * replace it with a full fledged one.
//   */
//  public void unRenderProxy(LayoutEnv oEnv);

////
//// Coordinate conversion functions
////
//// These functions convert between coordinates in model space to layout space and vice versa.
//// Consider an object, i.e. a field that is defined in that template as 15in high. Assume when paginated this field
//// is split across 3 pages, each piece being 5in high. 
//// Model space is that of the contiguous, unsplit 15in high field. 
//// Model-content/model-caption space simply refers to the contiguous unsplit content/caption subregions of the model space.
//// Layout space is local coordinate space of any one of the three layout nodes that represents a piece of the model field.
//// Layout-content/layout-caption space refers to the content/caption subregions of the layoutnode space.

//  /**
//   * Given a coord in model space this returns the corresponding layout node and a converted coord relative 
//   * to the top left of that layout node nominal extent.
//   * @param oModelPt IN: the coordinate in model space to convert to layout space
//   * @param oNode OUT: the specific layout node that represents the given model pt.  This may end up being the same node as 'this'
//   * @param oLocalPt OUT: a coordinate in layout space relative to the top left of the returned oNode parameter
//   * @return true if the coordinate is able to be converted, false otherwise. If false the returned value of other 
//   * parameters are undefined.    
//   */
//  public boolean modelToLayout(CoordPair oModelPt, LayoutNode oNode, CoordPair oLocalPt);

//  /**
//   * Given a coord in model-content/caption space this returns the corresponding layout node 
//   * and the converted coord relative to the top left of that layout nodes nominal extent.
//   * Model-content/caption space is the contiguous unsplit content/caption subregion of model space.
//   * @param oModelPt IN: the coordinate in model space to convert to layout space
//   * @param oNode OUT: refers to the specific layout node that represents the given model pt.  This may end up being the same node as 'this'
//   * @param oContentPt/oCaptionPt OUT: a coordinate in layout space relative to the top left of the returned oNode parameter
//   * @return true if the coordinate is able to be converted, false otherwise. If false the returned value of other 
//   * parameters are undefined.    
//   */
//  public boolean modelContentToLayout(CoordPair oModelPt, LayoutNode oNode, CoordPair oContentPt);
//  public boolean modelCaptionToLayout(CoordPair oModelPt, LayoutNode oLayoutNode, CoordPair oCaptionPt);

//  /**
//   * Given a coord relative to the topleft of this layout node this function returns a coord in model space
//   * @param oLayoutPt a coordinate to convert. It is relative to the top left of the calling object. 
//   * @return  the converted coordinate in model space.
//   * Passing in a negative coordinate is an error and will return (0,0)
//   */
//  public CoordPair layoutToModel(CoordPair oLayoutPt);

//  /*
//   * This function is that same layoutToModel() except it returns a coord relative to the model-content space.
//   * That is, the contiguous unsplit content subregions of the model space.
//   */
//  public CoordPair layoutToModelContent(CoordPair oLayoutPt);

//  /*
//   * This function is that same layoutToModel() except it returns a coord relative to the model-content space.
//   * That is, the contiguous unsplit caption subregions of the model space. Returns (0,0) if the object contains no caption.
//   */
//  public CoordPair layoutToModelCaption(CoordPair oLayoutPt);

//  /**
//   * Given a coord relative to the topleft of the calling node, returns a coord relative to the top left of
//   * the content region within the same layout node.
//   * @param oLayoutPt a coordinate to convert that is relative to the top left of the calling object's nominal extent. 
//   * Must not be negative.
//   * @return  the converted coordinate in layout-content space.
//   */
//  public CoordPair layoutToLayoutContent(CoordPair oLayoutPt);

//  /**
//   * Given acoord relative to the topleft of the calling node, returns a coord relative to the top left of
//   * the caption region within the same layout node, or (0,0) if there is no caption
//   * @param oLayoutPt a coordinate to convert that is relative to the top left of the calling object's nominal extent
//   * Must not be negative.
//   * @return  the converted coordinate in layout-content space. Returns (0,0) if there is no caption.
//   */
//  public CoordPair layoutToLayoutCaption(CoordPair oLayoutPt);    

//  /**
//   * Calculate and return the accumulated height of all existences of the associated
//   * with the calling object.
//   */
//  public UnitSpan modelHeight();

//  /**
//   * Returns the vertical range values that this layout node existence represents in terms of the model space.
//   */
//  public void modelTopBottomRange(UnitSpan oTop, UnitSpan oBottom);

}
