/*************************************************************************
 *
 *	File: PDF417EncoderException.java
 *
 **************************************************************************
 * 
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xfa.pmp.adobepdf417pmp;

import com.adobe.xfa.pmp.common.BarcodeEncoderException;

/**
 * Exception class for PDF417 Barcode
 */
public class PDF417EncoderException extends BarcodeEncoderException {
	private static final long serialVersionUID = 7335409144751950561L;
	private PDF417EncoderErrorCode errorCode;

	/**
	 * Creates an instance of PDF417EncoderException
	 * 
	 * @param errorCode
	 *            error code
	 */
	public PDF417EncoderException(PDF417EncoderErrorCode errorCode) {
		this.errorCode = errorCode;
	}

	/**
	 * Gets the error code
	 * 
	 * @return error code
	 */
	public PDF417EncoderErrorCode getErrorCode() {
		return errorCode;
	}
}
