/*************************************************************************
 *
 *	File: BarcodeGenerationParams.java
 *
 **************************************************************************
 * 
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xfa.pmp.common;

/**
 * Represents various parameters for Barcode appearance generation
 * @author shakumar
 */
public class BarcodeGenerationParams
{
    private String symbology;
    private int version;
    /* width, height of PaperMetaData image, in inches */
    private double width;
    private double height;
            
            /* resolution of image, in dots per inch */
            private int                resolution;

    /* caption (optional):  a label that can be displayed across the bottom of the PMD field */
            private String     caption;

    /* DataGlyph specific params */
    /* growth flags, indicating which direction the image may grow */
            private int         growthFlags;
    /* Cellsize (perhaps DataGlyph-specific) */
    private int         cellSize;
    /* errorCorrection, given as a percentage (i.e, 25 means 25% error correction). */
    private int         errorCorrection;
    
    /* PDF417 specific params */
            /* Width and Height are in number of pixels at the given resolution level */
    private int         xSymbolWidth;
    private int         xSymbolHeight;
    private int         numCodeWordCol;
    private int         numCodeWordRow;
    private int         eccLevel;
    
	public String getSymbology() {
		return symbology;
	}
	public void setSymbology(String symbology) {
		this.symbology = symbology;
	}
	public int getVersion() {
		return version;
	}
	public void setVersion(int version) {
		this.version = version;
	}
	public double getWidth() {
		return width;
	}
	public void setWidth(double width) {
		this.width = width;
	}
	public double getHeight() {
		return height;
	}
	public void setHeight(double height) {
		this.height = height;
	}
	public int getResolution() {
		return resolution;
	}
	public void setResolution(int resolution) {
		this.resolution = resolution;
	}
	public String getCaption() {
		return caption;
	}
	public void setCaption(String caption) {
		this.caption = caption;
	}
	public int getGrowthFlags() {
		return growthFlags;
	}
	public void setGrowthFlags(int growthFlags) {
		this.growthFlags = growthFlags;
	}
	public int getCellSize() {
		return cellSize;
	}
	public void setCellSize(int cellSize) {
		this.cellSize = cellSize;
	}
	public int getErrorCorrection() {
		return errorCorrection;
	}
	public void setErrorCorrection(int errorCorrection) {
		this.errorCorrection = errorCorrection;
	}
	public int getXSymbolWidth() {
		return xSymbolWidth;
	}
	public void setXSymbolWidth(int symbolWidth) {
		xSymbolWidth = symbolWidth;
	}
	public int getXSymbolHeight() {
		return xSymbolHeight;
	}
	public void setXSymbolHeight(int symbolHeight) {
		xSymbolHeight = symbolHeight;
	}
	public int getNumCodeWordCol() {
		return numCodeWordCol;
	}
	public void setNumCodeWordCol(int numCodeWordCol) {
		this.numCodeWordCol = numCodeWordCol;
	}
	public int getNumCodeWordRow() {
		return numCodeWordRow;
	}
	public void setNumCodeWordRow(int numCodeWordRow) {
		this.numCodeWordRow = numCodeWordRow;
	}
	public int getEccLevel() {
		return eccLevel;
	}
	public void setEccLevel(int eccLevel) {
		this.eccLevel = eccLevel;
	}
    
    
}
