/*************************************************************************
 *
 *	File: DataMatrixAsciiCompactor.java
 *
 **************************************************************************
 * 
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xfa.pmp.datamatrixpmp;

/**
 * Ported from DataMatrixAsciiCompactor.cpp
 */
class DataMatrixAsciiCompactor extends DataMatrixBaseCompactor {
	// ////////////////////////////////////////////////////////////////////
	/**
	 * Do the ASCII compaction.
	 * 
	 * @param message
	 *            - The input binary message.
	 */
	// ////////////////////////////////////////////////////////////////////
	void compact(char[] message) {
		m_codeWords.clear();
		m_valid = false;

		int messageSize = message.length;
		int idx;
		for (idx = 0; idx < messageSize; idx++) {
			char v = message[idx];

			// Is it a numeric character?
			if ((v >= 48) && (v <= 57)) {
				// See if the next value is numeric
				if (idx + 1 < messageSize) {
					char v1 = message[idx + 1];
					if ((v1 >= 48) && (v1 <= 57)) {
						// We have a two digit numeric value
						int val = (v - 48) * 10 + v1 - 48;
						int numericValue = (val + 130);
						m_codeWords.add(numericValue);
						idx++;
					} else {
						// We have a single digit
						if (v > 127) {
							v = (char) (v - 128);
							m_codeWords.add(235); // Upper shift
						}
						m_codeWords.add(v + 1);
					}
				} else {
					// We have a single digit at the end of the message
					if (v > 127) {
						v = (char) (v - 128);
						m_codeWords.add(235); // Upper shift
					}
					m_codeWords.add(v + 1);
				}
			} else {
				if (v > 127) {
					v = (char) (v - 128);
					m_codeWords.add(235); // Upper shift
				}
				m_codeWords.add(v + 1);
			}
		}

		// Find the symbol size that will fit the data.
		m_symbolSize = findSymbolSize(m_codeWords.size());
		if (m_symbolSize == -1)
			return; // Can't fit the data

		// Pad the data. No need to unlatch since we are in ASCII mode already.
		DataMatrixPadder.addPadding(m_codeWords, m_symbolSize);

		// It's a valid compaction.
		m_valid = true;
	}
}
