/*************************************************************************
 *
 *	File: DataMatrixBaseCompactor.java
 *
 **************************************************************************
 * 
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xfa.pmp.datamatrixpmp;

import java.util.ArrayList;
import java.util.List;

abstract class DataMatrixBaseCompactor {
	void getCodeWords(List<Integer> codeWords) {
		codeWords.addAll(m_codeWords);
	}

	boolean isValid() {
		return m_valid;
	}

	int getSymbolSize() {
		return m_symbolSize;
	}

	List<Integer> m_codeWords = new ArrayList<Integer>();

	int m_symbolSize = -1;

	boolean m_valid;

	int findSymbolSize(int codeWordSize) {
		for (int idx = 0; idx < DataMatrixInfo.Sizes.NUM_SQUARE_SIZES.value; idx++) {
			if (codeWordSize <= DataMatrixInfo.DATA_SYMBOLS[idx])
				return (idx);
		}
		return (-1);
	}
}
