/*************************************************************************
 *
 *	File: DataMatrixImageBuilder.java
 *
 **************************************************************************
 * 
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xfa.pmp.datamatrixpmp;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

/**
 * Ported from DataMatrixImageBuilder.cpp
 */
class DataMatrixImageBuilder {

	private static Color getColor(int color) {
		if (color == 0)
			return Color.BLACK;
		return Color.WHITE;
	}

	// ////////////////////////////////////////////////////////////////////
	/**
	 * Builds the in memory image of the barcode.
	 * 
	 * @throws DataMatrixEncoderException
	 */
	// ////////////////////////////////////////////////////////////////////
	static BufferedImage buildImage(DataMatrixMatrix matrix, int imageCols, // In:
																			// Desired
																			// columns
																			// in
																			// image.
			int imageRows, // In: Desired rows in image.
			int xDimension) throws DataMatrixEncoderException // In: size of the
																// module.
	{
		// Center the symbol in the image
		int cols = matrix.getCols();
		int rows = matrix.getRows();

		if (imageCols <= 0)
			imageCols = (cols + 2) * xDimension;
		if (imageRows <= 0)
			imageRows = (rows + 2) * xDimension;

		// Center the symbol in the image
		int colOffset = (imageCols - (cols * xDimension)) / 2;
		int rowOffset = (imageRows - (rows * xDimension)) / 2;
		// Enforce quiet zone of 1 module width all around.
		if ((colOffset < xDimension) || (rowOffset < xDimension))
			throw new DataMatrixEncoderException(
					DataMatrixEncoderErrorCode.IMAGE_TOO_SMALL);

		// Create the image
		BufferedImage image = new BufferedImage(imageCols, imageRows,
				BufferedImage.TYPE_BYTE_GRAY);
		Graphics2D graphicsBarcodeImage = image.createGraphics();
		graphicsBarcodeImage.setColor(Color.WHITE);
		graphicsBarcodeImage.fillRect(0, 0, Integer.MAX_VALUE,
				Integer.MAX_VALUE);
		graphicsBarcodeImage.clipRect(0, 0, imageCols - colOffset, imageRows
				- rowOffset);

		// Convert the matrix to an image.
		int imageCol;
		int imageRow;
		int color = 0;
		int i;
		int j;
		for (i = 0, imageRow = rowOffset; i < rows; i++, imageRow += xDimension) {
			for (j = 0, imageCol = colOffset; j < cols; j++, imageCol += xDimension) {
				color = matrix.get(j, i) != 0 ? 0 : 255;
				graphicsBarcodeImage.setColor(getColor(color));
				graphicsBarcodeImage.fillRect(imageCol, imageRow, imageCol
						+ xDimension, imageRow + xDimension);
			}
		}
		return (image);
	}
}
