/*************************************************************************
 *
 *	File: DataMatrixPadder.java
 *
 **************************************************************************
 * 
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xfa.pmp.datamatrixpmp;

import java.util.List;

/**
 * Ported from DataMatrixPadder.cpp
 */
class DataMatrixPadder {
	// ////////////////////////////////////////////////////////////////////
	/**
	 * Builds the in memory image of the barcode.
	 */
	// ////////////////////////////////////////////////////////////////////
	static void addPadding(List<Integer> codeWords, // In/Out: The barcode
			// message.
			int symbolSize) // In: size of the module.
	{
		// Pad data to fill the symbol
		int paddedCodeWords = DataMatrixInfo.DATA_SYMBOLS[symbolSize]
				- codeWords.size();
		for (int idx = 0; idx < paddedCodeWords; idx++) {
			if (idx == 0)
				codeWords.add(129);
			else
				codeWords.add(getPadding(129, codeWords.size() + 1)); // Apply
			// 253
			// state
			// randomization
		}
	}

	// ////////////////////////////////////////////////////////////////////
	/**
	 * Returns the 253 state randomization.
	 */
	// ////////////////////////////////////////////////////////////////////
	static int getPadding(int codeWord, int position) {
		int pseudoRandomNumber = ((149 * position) % 253) + 1;
		int t = codeWord + pseudoRandomNumber;
		if (t <= 254)
			return (t);
		return (t - 254);
	}
}
