/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2008 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.scripthandler.rhino;


import com.adobe.xfa.Obj;


/**
 * This is the interface that all RhinoScriptHandler objects
 * must implement.  Particularly, subclasses of RhinoScriptHandler
 * will need to provide their own implementation of this interface's
 * methods.
 * <p>
 * The interface provides methods to
 * <ul>
 * <li>instantiate a LiveObject object (or derivative).
 * <li>instantiate a LiveComponent object (or derivative).
 * </ul>
 *
 * @author Mike Tardif
 */
public interface ScriptHandlerIF {
    
    /**
     * Instantiates a new LiveObject.
     * @param handler a Rhino script handler.
     * @param xfaObject the XFA object that is peered to this instance.
     * @return the LiveObject.
     */
    LiveObject newLiveObject(RhinoScriptHandler handler, Obj xfaObject);

    /**
     * Instantiates a new LiveComponent.
     * @param handler a Rhino script handler.
     * @param xfaObject the XFA object (app model) associated with the given script handler.
     * @return the LiveComponent.
     */
    LiveComponent newLiveComponent(RhinoScriptHandler handler, Obj xfaObject);

}
