package com.adobe.xfa.template;

import com.adobe.xfa.Element;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.XFA;

/**
 * DUMMY class so that instance managers show up in the scripting API in designer.
 * 
 * @exclude from published api
 */

public class InstanceManager extends Obj {

	private final Element moParent;

	public InstanceManager(Element parent) {
		moParent = parent;
	}
	
	// XFA SCRIPT SUPPORT
	public ScriptTable getScriptTable() {
		return InstanceManagerScript.getScriptTable();
	}

	public Element getOccur() {
		if (moParent != null)
			return moParent.getElement(XFA.OCCURTAG, 0);
		return null;
	}


}
