/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template;


import com.adobe.xfa.Arg;
import com.adobe.xfa.ModelScript;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.ScriptFuncObj;
import com.adobe.xfa.XFA;


/**
 * This class contains all the script functionality associated with the
 * TemplateModel class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class TemplateModelScript extends ModelScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ModelScript.moScriptTable,
		"template",
		null,
		new ScriptFuncObj[] {
			new ScriptFuncObj(TemplateModelScript.class, "createNode", "createNode", Arg.OBJECT,
				new int[] { Arg.STRING, Arg.STRING /*, XFA_IS_TEMPLATE_CREATENODE_PARAM1, XFA_IS_TEMPLATE_CREATENODE_PARAM2*/ }, 1, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_TEMPLATE_CREATENODE_DESC, XFA_IS_TEMPLATE_CREATENODE_RET*/, 0),
			new ScriptFuncObj(TemplateModelScript.class, "recalculate", "recalculate", Arg.EMPTY,
				new int[] { Arg.BOOL /*, XFA_IS_FORM_RECALCULATE_PARAM1*/ }, 1, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_RECALCULATE_DESC, 0*/, 0),
			new ScriptFuncObj(TemplateModelScript.class, "remerge", "remerge", Arg.EMPTY,
				new int[] { }, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_REMERGE_DESC, 0*/, 0),
			new ScriptFuncObj(TemplateModelScript.class, "formNodes", "formNodes", Arg.OBJECT,
				new int[] { Arg.OBJECT /*, XFA_IS_FORM_FORMNODES_PARAM1*/ }, 1, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_FORMNODES_DESC, XFA_IS_FORM_FORMNODES_RET*/, 0),
			new ScriptFuncObj(TemplateModelScript.class, "execCalculate", "execCalculate", Arg.EMPTY,
				new int[] { }, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/*, XFA_IS_FORM_RECALCULATE_DESC, 0*/, 0),
			new ScriptFuncObj(TemplateModelScript.class, "execValidate", "execValidate", Arg.EMPTY,
				new int[] { }, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/*, XFA_IS_FORM_EXECVALIDATE_DESC, 0*/, 0),
			new ScriptFuncObj(TemplateModelScript.class, "execInitialize", "execInitialize", Arg.EMPTY,
				new int[] { }, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/*, XFA_IS_FORM_EXECINITIALIZE_DESC, 0*/, 0),
			new ScriptFuncObj(TemplateModelScript.class, "metadata", "metadata", Arg.STRING,
				new int[] { }, 0, Schema.XFAVERSION_26, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_METADATA_DESC,XFA_IS_FORM_METADATASTRING_RET*/, 0)
		}
	);

	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void createNode(Obj obj, Arg oRetVal, Arg[] args) {
		String prop = args[0].getString().intern();
		int eTag = XFA.getTag(prop);
		if (eTag > -1) {
			if (args.length == 1)
				oRetVal.setObject(((TemplateModel) obj).createNode(eTag, null, "", "", true));
			else
				oRetVal.setObject(((TemplateModel) obj).createNode(eTag, null, args[1].getString().intern(), "", true));
		}
	}

	/*
	 * The next methods are just for the designer intellisence
	 * since they don't have a form DOM but still want to be
	 * able to see the form properties & methods after doing
	 * $form.
	 */

	public static void recalculate(Obj obj, Arg retVal, Arg[] args) {
		((TemplateModel) obj).invalidMethod("recalculate");
	}

	public static void remerge(Obj obj, Arg retVal, Arg[] args) {
		((TemplateModel) obj).invalidMethod("remerge");
	}

	public static void formNodes(Obj obj, Arg retVal, Arg[] args) {
		((TemplateModel) obj).invalidMethod("formNodes");
	}

	public static void execCalculate(Obj obj, Arg retVal, Arg[] args) {
		((TemplateModel) obj).invalidMethod("execCalculate");
	}

	public static void execValidate(Obj obj, Arg retVal, Arg[] args) {
		((TemplateModel) obj).invalidMethod("execValidate");
	}

	public static void execInitialize(Obj obj, Arg retVal, Arg[] args) {
		((TemplateModel) obj).invalidMethod("execInitialize");
	}
	
	public static void metadata(Obj obj, Arg retVal, Arg[] args) {
		((TemplateModel)obj).invalidMethod("metadata");
	}
}
