/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template.automation;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.ut.StringUtils;

/**
 * @exclude from published api.
 */
public class Calculate extends ProtoableNode {
	
	public Calculate(Element pParent, Node prevSibling) {
		super(pParent, prevSibling, null, XFA.CALCULATE, XFA.CALCULATE, null,
				XFA.CALCULATETAG, XFA.CALCULATE);
	}
	
	/**
	 * @exclude from published api.
	 */
	public Attribute defaultAttribute(int eTag) {
		
		if (eTag == XFA.OVERRIDETAG) {
			// The syntax chart in the spec says "disabled" is the default.  
			// The text then goes on to say that "error" is the default if the calculate element is included
			Element poScript = getElement(XFA.SCRIPTTAG, true, 0, false, false);

			// if we don't have a script then the user can override the value
			if (poScript == null)
				return super.defaultAttribute(eTag);

			TextNode poText = poScript.getText(true, false, false);
			if (poText == null)
				return super.defaultAttribute(eTag);

			String sScript = poText.getValue();
			if (StringUtils.isEmpty(sScript))
				return super.defaultAttribute(eTag);

			// watson bug 1440694  old 7.0 forms don't respect the override attribute, 
			// must continue to respect this
			if (!getAppModel().getLegacySetting(AppModel.XFA_LEGACY_CALCOVERRIDE))
				return EnumValue.getEnum(XFA.OVERRIDETAG, EnumAttr.OVERRIDE_ERROR);
		}

		// Not  special case, so let the base class handle it
		return super.defaultAttribute(eTag);
	}
}
