/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa.template.binding;

import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;

/**
 * This class represents the functionality of the bind element in the XFA
 * grammar.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public final class Bind extends BindingNode {

	public Bind(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.BIND, XFA.BIND, null, XFA.BINDTAG, XFA.BIND);
	}

	public void updateAbsoluteDataRef() {
		String sRef="";
		if (getEnum(XFA.MATCHTAG) == EnumAttr.MATCH_DATAREF)
			sRef = getAttribute(XFA.REFTAG).toString();

		updateAbsoluteDataRef(sRef, "", EnumAttr.UNDEFINED, false);
	}

	String getBindingContext() {
		return getContextRef(getXFAParent(), "", EnumAttr.UNDEFINED);
	}

}
