/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template.binding;

import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;

/**
 * An element that describes complex binding for properties of a container
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public final class SetProperty extends BindingNode {
	public SetProperty(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.SETPROPERTY, XFA.SETPROPERTY,
				null, XFA.SETPROPERTYTAG, XFA.SETPROPERTY);
	}

	public String getBindingContext() {
		String sConnection = getAttribute(XFA.CONNECTIONTAG).toString();
		int eUsage = EnumAttr.UNDEFINED;
		if (sConnection.length() > 0)
			eUsage = EnumAttr.USAGE_IMPORTONLY;

		return getContextRef(this, sConnection, eUsage);
	}

	public void updateAbsoluteDataRef() {
		String sRef = getAttribute(XFA.REFTAG).toString();
		String sConnection = getAttribute(XFA.CONNECTIONTAG).toString();
		int eUsage = EnumAttr.UNDEFINED;
		if (sConnection.length() > 0)
			eUsage = EnumAttr.USAGE_IMPORTONLY;

		updateAbsoluteDataRef(sRef, sConnection, eUsage, true);
	}
}
