/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template.containers;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;

/**
 * Implement functionality behind the XFA <code>area</code> object.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public final class AreaContainer extends Container {

	/**
	 * Constructor.
	 * 
	 * @param pParent -
	 *            Parent element to add this node to
	 * @param prevSibling -
	 *            For efficiency provide the sibling to link to
	 */
	public AreaContainer(Element pParent, Node prevSibling) {
		super(pParent, prevSibling, null, XFA.AREA, XFA.AREA, null,
				XFA.AREATAG, XFA.AREA);

		setTransparent(true);
	}

	/**
	 * @see Container#isHeightGrowSupported()
	 */
	public boolean isHeightGrowSupported() {
		return false;
	}

	/**
	 * @see Container#isWidthGrowSupported()
	 */
	public boolean isWidthGrowSupported() {
		return false;
	}

}
