/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template.containers;


import com.adobe.xfa.Arg;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Model;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ProtoableNodeScript;
import com.adobe.xfa.ScriptFuncObj;
import com.adobe.xfa.ScriptTable;


/**
 * This class contains all the script functionality associated with the
 * Container class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class ContainerScript extends ProtoableNodeScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ProtoableNodeScript.moScriptTable,
		"container",
		null,
		new ScriptFuncObj[] {
			new ScriptFuncObj(ContainerScript.class, "getDeltas", "getDeltas", Arg.OBJECT,
				new int[] { }, 0, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_GETDELTAS_DESC, XFA_IS_GETDELTAS_RET, null*/, 0),
			new ScriptFuncObj(ContainerScript.class, "getDelta", "getDelta", Arg.OBJECT,
				new int[] { Arg.STRING/*, XFA_IS_GETDELTA_PARAM */}, 1, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_GETDELTA_DESC, XFA_IS_GETDELTA_RET, null*/, 0) 
		}
	);

	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void getDeltas(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		Model oModel = ((Container) pObj).getModel();
		if (oModel != null) {
			Obj oList = oModel.getDeltas(((Container) pObj));
			oRetVal.setObject(oList);
		}
	}

	public static void getDelta(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		Model oModel = ((Container) pObj).getModel();
		if (oModel != null) {
			Obj oDelta = oModel.getDelta(((Container) pObj), pArgs[0].getString());
			oRetVal.setObject(oDelta);
		}
	}

}
