/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template.containers;


import com.adobe.xfa.Arg;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptPropObj;
import com.adobe.xfa.ScriptTable;


/**
 * This class contains all the script functionality associated with the
 * Draw class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class DrawScript extends ContainerScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ContainerScript.moScriptTable,
		"draw",
		new ScriptPropObj[] {
			new ScriptPropObj(DrawScript.class, "rawValue", "getRawValue", "setRawValue", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_DRAW_RAWVALUE_DESC, 0*/, 0),
			new ScriptPropObj(DrawScript.class, null, "getRawValue", "setRawValue", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_DRAW_RAWVALUE_DESC, 0*/, 0)
		},
		null
	);

	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void getRawValue(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Draw) pObj).getRawValue());
	}

	public static void setRawValue(Obj pObj, Arg propertyValue) {
		((Draw) pObj).setRawValue(propertyValue.getString());
	}

}
