package com.adobe.xfa.template.containers;

import com.adobe.xfa.Arg;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptDynamicPropObj;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.XFA;

import com.adobe.xfa.template.InstanceManager;


/**
 * An element that describes a set of related subform objects.
 * <p>
 * A subformSet has an attribute called relation, that describes the
 * relationship between the subforms contained in the subform set. The value of
 * the relation attribute can be on of "ordered", "unordered", or "choice".
 * <p>
 * When the subforms in a subformSet are dynamically created based on the data
 * specified for the template, it is the relation attribute which defines in
 * what order the subforms will be instantiated.
 * <p>
 * Let's take the following example:
 * 
 * <code>
 * <xfa>
 *   <template>
 *     <subform>
 *       <area>
 *         <subform name="a"/>
 *         <subformSet relation="unordered">
 *           <subform name="b"/>
 *           <subform name="c"/>
 *         </subformSet>
 *         <subform name="d"/>
 *       </area>
 *     </subform>
 *   </template>
 * </xfa>
 * </code>
 *<pre>
 * 
 *  Example 1:
 *  In this example with relation set to &quot;unordered&quot;, we can expect to see forms
 *  with the following structures:
 * 
 *  &quot;abcd&quot;
 *  &quot;acbd&quot;
 *  &quot;acccbbbcbbbbbcbcbd&quot;
 * 
 *  subforms &quot;c&quot; and &quot;b&quot; can appear in any order.&lt;br/&gt;
 * 
 *  Example 2:
 *  If the relation attribute was &quot;ordered&quot; we can expect to see forms with the
 *  following structure:&lt;br/&gt;
 * 
 *  &quot;abcd&quot;
 *  &quot;abbbbbbbbbcccccccccd&quot;
 * 
 *  subforms &quot;b&quot; and &quot;c&quot; must appear in the order they appear in the
 *  subform set.
 * 
 *  Example 3:
 *  finally, if the relation attribute was &quot;choice&quot;, we can expect to see forms
 *  with the following structure:
 * 
 *  &quot;abd&quot;
 *  &quot;acd&quot;
 *  &quot;abbbbbbbbbbbbd&quot;
 *  &quot;accccccccccccd&quot;
 * 
 *  Where you only have a choice of &quot;b&quot; or &quot;c&quot; from the available subforms in
 *  the subformSet.
 * 
 * </pre>
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public class SubformSet extends Container {
	/**
	 * <pre>
	 * 
	 *                    index  Used
	 *     overflowLeader[     |     ]
	 *   overflowTtrailer[     |     ]
	 *      bookendLeader[     |     ]
	 *     bookendTrailer[     |     ]
	 *  
	 * </pre>
	 */
	//private int[][] mppnUsedTable;	// Doesn't appear to be used anywhere

	public SubformSet(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.SUBFORMSET, XFA.SUBFORMSET,
				null, XFA.SUBFORMSETTAG, XFA.SUBFORMSET);
		//mppnUsedTable = null;
		setTransparent(true);
	}

	/**
	 * @exclude from public api.
	 */
	public void reset() {
		//mppnUsedTable = null;
	}

	public boolean isWidthGrowSupported() {
		return false;
	}

	public boolean isHeightGrowSupported() {
		return false;
	}
	
	public int[][] getUsedTable() {
		//return mppnUsedTable;
		return null;
	}

	/**
	 * @exclude from public api.
	 */
	protected int getInstanceIndex(DependencyTracker pDepTrack) {
		// Form method only
		return 0;
	}

	/**
	 * @exclude from public api.
	 */
	public void setInstanceIndex(int nIndex) {
		// Form method only
	}

	/**
	 * @exclude from public api.
	 */
	public Obj getInstanceManager() {
		// create a new instance manager
		return new InstanceManager(this);
	}

	/**
	 * @exclude from published api.
	 */
	public ScriptTable getScriptTable() {
		return SubformSetScript.getScriptTable();
	}

	/**
	 * @exclude from published api.
	 */
	protected ScriptDynamicPropObj getDynamicScriptProp(String sPropertyName,
			boolean bPropertyOverride, boolean bPeek) {
		// if the first char of sPropertyName is '_'  check for a same name 
		// subform or subformset child. If we find one return the instance manager.
		if (sPropertyName.length() > 0 && sPropertyName.charAt(0) == '_') {
			String sNewName = sPropertyName.substring(1);
			if (sNewName.length() > 0) {
				Node oChild = locateChildByName(sNewName, 0);
				if ((oChild instanceof Subform) ||
					(oChild instanceof SubformSet)) {
					
					return getInstanceManagerScriptObj;
				}
			}
		}

		return super.getDynamicScriptProp(sPropertyName, bPropertyOverride, bPeek);
	}
	
	private final static ScriptDynamicPropObj getInstanceManagerScriptObj = 
		new ScriptDynamicPropObj(Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL) {
		
		public boolean invokeGetProp(Obj scriptThis, Arg retValue, String sPropertyName) {
			return SubformSet.getInstanceManagerFunc(scriptThis, retValue, sPropertyName);
		}
	};

	private static boolean getInstanceManagerFunc(Obj oObj, Arg oRetVal, String sProp) {
		SubformSet oSubSet = (SubformSet)oObj;
		oRetVal.setObject(oSubSet.getInstanceManager());
		return true;
	}
}
