/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template.containers;


import com.adobe.xfa.Arg;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptPropObj;
import com.adobe.xfa.ScriptTable;


/**
 * This class contains all the script functionality associated with the
 * SubformSet class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class SubformSetScript extends ContainerScript {

	static final ScriptTable moScriptTable = new ScriptTable(
		ContainerScript.moScriptTable,
		"subformSet",
		new ScriptPropObj[] {
			new ScriptPropObj(SubformSetScript.class, "instanceManager", "getInstanceManager", null, Arg.OBJECT, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_INSTANCEMANAGER_DESC, 0*/, 0),
			new ScriptPropObj(SubformSetScript.class, "instanceIndex", "getInstanceIndex", "setInstanceIndex", Arg.INTEGER, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_INSTANCEINDEX_DESC, 0*/, 0)
		},
		null
	);

	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void getInstanceManager(Obj pObj, Arg oRetVal) {
		oRetVal.setObject(((SubformSet) pObj).getInstanceManager());
	}

	public static void getInstanceIndex(Obj pObj, Arg oRetVal, DependencyTracker pDepTrack) {
		oRetVal.setInteger(Integer.valueOf(((SubformSet) pObj).getInstanceIndex(pDepTrack)));
	}

	public static void setInstanceIndex(Obj pObj, Arg propertyValue) {
		if (propertyValue.getArgType() != Arg.NULL)
			((SubformSet) pObj).setInstanceIndex(propertyValue.getInteger().intValue());
	}
}
