/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template.containers;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;

/**
 * functionality represented by the XFA <variables> element.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public final class Variables extends Container {

	public Variables(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.VARIABLES, XFA.VARIABLES,
				null, XFA.VARIABLESTAG, XFA.VARIABLES);
		setTransparent(true);
	}

	public boolean isHeightGrowSupported() {
		return false;
	}

	public boolean isWidthGrowSupported() {
		return false;
	}

	public boolean isTransparent() {
	    return true;
	}
}
