package com.adobe.xfa.text;

import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.Rect;

/*
 * @exclude from published api.
 */

class ABXY {

	static CoordPair toXY (CoordPair oXYOrigin, CoordPair oAB, int eOrientation) {
		if (eOrientation == TextAttr.ORIENTATION_HORIZONTAL) {
			return oAB.add (oXYOrigin);
		} else {
			return new CoordPair (oXYOrigin.x().subtract (oAB.y()),
								  oXYOrigin.y().add (oAB.x()));
		}
	}

	static CoordPair toAB (CoordPair oXYOrigin, CoordPair oXY, int eOrientation) {
		if (eOrientation == TextAttr.ORIENTATION_HORIZONTAL) {
			return oXY.subtract (oXYOrigin);
		} else {
			return new CoordPair (oXY.y().subtract (oXYOrigin.y()),
								  oXY.x().subtract (oXYOrigin.x()));
		}
	}

	static Rect toXY (CoordPair oXYOrigin, Rect oAB, int eOrientation) {
		if (eOrientation == TextAttr.ORIENTATION_HORIZONTAL) {
			return oAB.add (oXYOrigin);
		} else {
			CoordPair oTL = toXY (oXYOrigin, oAB.topLeft(), eOrientation);
			CoordPair oBR = toXY (oXYOrigin, oAB.bottomRight(), eOrientation);
			return new Rect (oTL.x(), oTL.y(), oBR.x(), oBR.y());
		}
	}

	static Rect toAB (CoordPair oXYOrigin, Rect oXY, int eOrientation) {
		if (eOrientation == TextAttr.ORIENTATION_HORIZONTAL) {
			return oXY.subtract (oXYOrigin);
		} else {
			CoordPair oTL = toAB (oXYOrigin, oXY.topLeft(), eOrientation);
			CoordPair oBR = toAB (oXYOrigin, oXY.bottomRight(), eOrientation);
			return new Rect (oTL.x(), oTL.y(), oBR.x(), oBR.y());
		}
	}

	static DispRect toXY (CoordPair oXYOrigin, DispRect oAB, int eOrientation) {
		DispRect oResult = new DispRect (oAB);
		toXY (oXYOrigin, eOrientation, oResult);
		return oResult;
	}

	static void toXY (CoordPair oXYOrigin, int eOrientation, DispRect oConvert) {
		float oOriginX = Units.toFloat (oXYOrigin.x());
		float oOriginY = Units.toFloat (oXYOrigin.y());

		if (eOrientation == TextAttr.ORIENTATION_HORIZONTAL) {
			oConvert.xMin += oOriginX;
			oConvert.yMin += oOriginY;
			oConvert.xMax += oOriginX;
			oConvert.yMax += oOriginY;
		} else {
			float oLeft = oConvert.xMin;
			oConvert.xMin = oOriginX - oConvert.yMax;
			oConvert.yMax = oOriginY + oConvert.xMax;
			oConvert.xMax = oOriginX - oConvert.yMin;
			oConvert.yMin = oOriginY + oLeft;
		}
	}

	static DispRect toAB (CoordPair oXYOrigin, DispRect oXY, int eOrientation) {
		DispRect oResult = new DispRect (oXY);
		toAB (oXYOrigin, eOrientation, oResult);
		return oResult;
	}

	static void toAB (CoordPair oXYOrigin, int eOrientation, DispRect oConvert) {
		float oOriginX = Units.toFloat (oXYOrigin.x());
		float oOriginY = Units.toFloat (oXYOrigin.y());

		if (eOrientation == TextAttr.ORIENTATION_HORIZONTAL) {
			oConvert.xMin -= oOriginX;
			oConvert.yMin -= oOriginY;
			oConvert.xMax -= oOriginX;
			oConvert.yMax -= oOriginY;
		} else {
			float oLeft = oConvert.xMin;
			oConvert.xMin = oConvert.yMin - oOriginY;
			oConvert.yMin = oOriginX - oConvert.xMax;
			oConvert.xMax = oConvert.yMax - oOriginY;
			oConvert.yMax = oOriginY - oLeft;
		}
	}

	static DispPoint toXY (CoordPair oXYOrigin, DispPoint oAB, int eOrientation) {
		return toXY (oXYOrigin, oAB.x, oAB.y, eOrientation);
	}

	static DispPoint toXY (CoordPair oXYOrigin, float oA, float oB, int eOrientation) {
		float oOriginX = Units.toFloat (oXYOrigin.x());
		float oOriginY = Units.toFloat (oXYOrigin.y());

		return (eOrientation == TextAttr.ORIENTATION_HORIZONTAL)
			? new DispPoint (oA + oOriginX, oB + oOriginY)
			: new DispPoint (oOriginX - oB, oOriginY + oA);
	}

	static DispPoint toAB (CoordPair oXYOrigin, DispPoint oXY, int eOrientation) {
		return toAB (oXYOrigin, oXY.x, oXY.y, eOrientation);
	}

	static DispPoint toAB (CoordPair oXYOrigin, float oX, float oY, int eOrientation) {
		float oOriginX = Units.toFloat (oXYOrigin.x());
		float oOriginY = Units.toFloat (oXYOrigin.y());

		return (eOrientation == TextAttr.ORIENTATION_HORIZONTAL)
			? new DispPoint (oX - oOriginX, oY - oOriginY)
			: new DispPoint (oOriginX - oY, oX - oOriginY);
	}
}
