package com.adobe.xfa.text;

/**
 * @exclude from published api.
 */

class DispPosn extends DispMapItem {
	private int mnStreamCount;
	private TextPosn moPosn;

	DispPosn () {
		mnStreamCount = 0;
	}

	DispPosn (DispPosn oSource) {
		super (oSource);
		moPosn = new TextPosn (oSource.moPosn);
		mnStreamCount = oSource.mnStreamCount;
	}

	DispPosn (DispPosn oSource, int index, int length) {
		super (index, length);
		moPosn = new TextPosn (oSource.moPosn);
		mnStreamCount = oSource.mnStreamCount;
	}

	DispPosn (TextPosn oSource) {
		moPosn = new TextPosn (oSource);
		mnStreamCount = 0;
	}

	DispPosn (TextPosnBase oSource) {
		moPosn = new TextPosn (oSource);
		mnStreamCount = 0;
	}

	DispPosn (TextStream poStream, int nIndex, int ePosn) {
		moPosn = new TextPosn (poStream, nIndex, ePosn);
		mnStreamCount = 0;
	}

	DispPosn (TextStream poStream, int nIndex) {
		this (poStream, nIndex, TextPosn.POSN_AFTER);
		mnStreamCount = 0;
	}

	TextPosn pp () {
		return moPosn;
	}

	int getStreamCount () {
		return mnStreamCount;
	}

	void setStreamCount (int nStreamCount) {
		mnStreamCount = nStreamCount;
	}

	static void split (DispPosn oPosn, int nSplit) {	// TODO: is this needed?
		oPosn.moPosn.index (oPosn.moPosn.index() + nSplit);
	}

	void copyFrom (DispPosn oSource) {
		super.copyFrom (oSource);
		moPosn = new TextPosn (oSource.moPosn);
		mnStreamCount = oSource.mnStreamCount;
	}

	void copyFrom (TextPosn oSource) {			// TODO: is this overload needed?
		moPosn = new TextPosn (oSource);
		mnStreamCount = 0;
	}

	void copyFrom (TextPosnBase oSource) {		// TODO: is this overload needed?
		moPosn = new TextPosn (oSource);
		mnStreamCount = 0;
	}

	DispPosn p () {
		return this;
	}

	void add (DispLine line, int start, int length) {
		line.add (this, start, length);
	}

	DispMapItem cloneMapItem () {
		return new DispPosn (this);
	}

	DispMapItem cloneMapItem (int index, int length) {
		return new DispPosn (this, index, length);
	}

	void copyFrom (DispMapItem source) {
		assert (source instanceof DispPosn);
		copyFrom ((DispPosn) source);
	}
}
