package com.adobe.xfa.text;

import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.UnitSpan;

/**
 * @exclude from published api.
 */

class FrameDispInfo extends FrameHelper {
	private Rect moExtent;
	private boolean mbExtended;
	private boolean mbStarted;

	public FrameDispInfo (TextSparseStream poStream, boolean bExtended, int eProcess) {
		super (poStream, eProcess);
		mbExtended = bExtended;
		//mbStarted = false;
	}

	public FrameDispInfo (TextSparseStream poStream, boolean bExtended) {
		this (poStream, bExtended, PROCESS_LOADED_FRAMES);
	}

	public Rect getExtent () {
		return moExtent;
	}

	protected boolean processOneFrame (TextFrame poFrame) {
		if (poFrame != null) {
			if (! mbStarted) {
				mbStarted = true;
				moExtent = poFrame.runtimeExtent (mbExtended);
			} else {
				Rect oFrameExtent = poFrame.runtimeExtent (mbExtended);
				oFrameExtent = oFrameExtent.add (new CoordPair (UnitSpan.ZERO, getOffset()));
				if (moExtent == null) {
					moExtent = oFrameExtent;
				} else {
					moExtent = moExtent.union (oFrameExtent);
				}
			}
		}
		return true;
	}
}
