package com.adobe.xfa.text;

/**
 * @exclude from published api.
 */

class FrameGfxDraw extends FrameHelper {
	private final DrawParm moParm;
	private boolean mbFits;

	FrameGfxDraw (TextSparseStream poStream, DrawParm oParm, int eProcess) {
		super (poStream, eProcess);
		moParm = oParm;
		mbFits = true;
	}

	FrameGfxDraw (TextSparseStream poStream, DrawParm oParm) {
		this (poStream, oParm, PROCESS_LOADED_FRAMES);
	}

	boolean fits () {
		return mbFits;
	}

	protected boolean processOneFrame (TextFrame poFrame) {
		if (poFrame != null) {
			boolean bFits = poFrame.gfxDraw (moParm, getOffset());
			if (! bFits) {
				mbFits = false;
			}
		}
		return true;
	}
}
