package com.adobe.xfa.text;

/**
 * @exclude from published api.
 */

abstract class FrameLineHelper extends FrameHelper {
	private DispLineWrapped mpoLine;

	FrameLineHelper (TextSparseStream poStream, int eProcess) {
		super (poStream, eProcess);
		mpoLine = null;
	}

	protected boolean processOneFrame (TextFrame poFrame) {
		if (poFrame != null) {
			int nAbsLineIndex = getAbsLineIndex();
			int nLines = poFrame.getLineCount();

			for (int i = 0; i < nLines; i++) {
				setLineIndex (i);
				setAbsLineIndex (nAbsLineIndex + i);
				mpoLine = poFrame.getLine (i);

				if (! processOneLine (mpoLine)) {
					return false;
				}
			}
		}

		return true;
	}

	protected boolean finish () {
		mpoLine = null;
		return true;
	}

	abstract boolean processOneLine (DispLineWrapped poLine);
}
