package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXGlyphOrientation;

/*
 * @exclude from published api.
 */

class Glyph {
	private int mnGlyph;
	private float moOriginalX;
	private float moOriginalNextX;
	private boolean mbRTL;
	private boolean mbShifted;
	private boolean mbSpreadOffset;
	private boolean mbComb;
	private boolean mbInMultiple;
	private boolean mbAXTELigature;
	private boolean mbRenderByGlyphID;
	private int meGlyphOrientation = GFXGlyphOrientation.HORIZONTAL;
	private int mnExtraIndex = -1;

	Glyph () {
	}

	int getExtraIndex () {
		return mnExtraIndex;
	}

	void setExtraIndex (int nExtraIndex) {
		mnExtraIndex = nExtraIndex;
	}

	boolean hasExtra () {
		return (mnExtraIndex >= 0);
	}

	GlyphExtra getExtra (DispLine poLine) {
		return hasExtra() ? poLine.getGlyphExtra (mnExtraIndex) : null;
	}

	int getGlyph () {
		return mnGlyph;
	}

	void setGlyph (int nGlyph) {
		mnGlyph = nGlyph;
	}

	boolean renderByGlyphID () {
		return mbRenderByGlyphID;
	}

	void setRenderByGlyphID (boolean bRenderByGlyphID) {
		mbRenderByGlyphID = bRenderByGlyphID;
	}

	float getDrawX (DispLine poLine) {
// Note: C++ implementation differs, doing all that funky stuff with
// glyph width and RTL width mandated by WRServices.  AFE doesn't have
// the same requirements.
		return moOriginalX + getOffsetX (poLine);
	}

	float getDrawY (DispLine poLine) {
		return getOriginalY (poLine);
	}

	float getDrawNextX (DispLine poLine) {
		return moOriginalNextX + getOffsetX (poLine);
	}

	float getOriginalX () {
		return moOriginalX;
	}

	void setOriginalX (float oOriginalX) {
		moOriginalX = oOriginalX;
	}

	float getOriginalY (DispLine poLine) {
		return hasExtra() ? getExtra (poLine).getY() : 0.0F;
	}

	float getOriginalNextX () {
		return moOriginalNextX;
	}

	void setOriginalNextX (float oOriginalNextX) {
		moOriginalNextX = oOriginalNextX;
	}

	void shift (float oDelta) {
		moOriginalX += oDelta;
		moOriginalNextX += oDelta;
	}

	void setComb (DispLine poLine, float oDelta, float oOriginalNextX) {
		assert (hasExtra());	// TODO:
		GlyphExtra poExtra = poLine.getGlyphExtra (mnExtraIndex);
		mbComb = true;
		poExtra.setWidth (moOriginalNextX - moOriginalX);
		poExtra.setRTLWidth (poExtra.getWidth());
		poExtra.setOffsetX (poExtra.getOffsetX() + oDelta);
	}

	void setOrientation (int eGlyphOrientation) {
		meGlyphOrientation = eGlyphOrientation;
	}

	float getWidth (DispLine poLine) {
		return hasExtra() ? getExtra (poLine).getWidth() : (moOriginalNextX - moOriginalX);
	}

	float getOffsetX (DispLine poLine) {
		return hasExtra() ? getExtra (poLine).getOffsetX() : 0.0F;
	}

	float getRTLWidth (DispLine poLine) {
		return hasExtra() ? getExtra (poLine).getRTLWidth() : 0.0F;
	}

	void setRTL (boolean bRTL) {
		mbRTL = bRTL;
	}

	boolean isRTL () {
		return mbRTL;
	}

	boolean isShifted () {
		return mbShifted;
	}

	void setShifted (boolean bShifted) {
		mbShifted = bShifted;
	}

	boolean isSpreadOffset () {
		return mbSpreadOffset;
	}

	void setSpreadOffset (boolean bSpreadOffset) {
		mbSpreadOffset = bSpreadOffset;
	}

	boolean isComb () {
		return mbComb;
	}

	boolean isInMultiple () {
		return mbInMultiple;
	}

	void setInMultiple (boolean bInMultiple) {
		mbInMultiple = bInMultiple;
	}

	boolean isAXTELigature () {
		return mbAXTELigature;
	}

	void setAXTELigature (boolean bAXTELigature) {
		mbAXTELigature = bAXTELigature;
	}

	int getGroup (DispLine poLine) {
		return hasExtra() ? getExtra (poLine).getGroup() : 0;
	}

	int getOrientation () {
		return meGlyphOrientation;
	}
}

class GlyphExtra {
	private float moOffsetX;
	private float moY;
	private float moWidth;
	private float moRTLWidth;
	private int mnGroup;

	GlyphExtra () {
	}

	float getOffsetX () {
		return moOffsetX;
	}

	void setOffsetX (float oOffsetX) {
		moOffsetX = oOffsetX;
	}

	float getY () {
		return moY;
	}

	void setY (float oY) {
		moY = oY;
	}

	float getWidth () {
		return moWidth;
	}

	void setWidth (float oWidth) {
		moWidth = oWidth;
	}

	float getRTLWidth () {
		return moRTLWidth;
	}

	void setRTLWidth (float oRTLWidth) {
		moRTLWidth = oRTLWidth;
	}

	int getGroup () {
		return mnGroup;
	}

	void setGroup (int nGroup) {
		mnGroup = nGroup;
	}

	void reset () {
		moOffsetX = 0.0F;
		moY = 0.0F;
		moRTLWidth = 0.0F;
		mnGroup = 0;
	}
}
