//----------------------------------------------------------------------
//
//	ADOBE CONFIDENTIAL
//	__________________
//
//		Copyright 1995 - 2004 Adobe Systems Incorporated.  All
//		Rights Reserved.
//
//		NOTICE:  All information contained herein is, and remains
//		the property of Adobe Systems Incorporated and its
//		suppliers, if any.	The intellectual and technical
//		concepts contained herein are proprietary to Adobe Systems
//		Incorporated and its suppliers and may be covered by U.S.
//		and Foreign Patents, patents in process, and are protected
//		by trade secret or copyright law.  Dissemination of this
//		information or reproduction of this material is strictly
//		forbidden unless prior written permission is obtained from
//		Adobe Systems Incorporated.
//
//	Description
//	___________
//
//		This class represents a temporary marker returned by the
//		TextPosnBase if MkBase::MarkerStart().	It caches the
//		start of the marker range along with a clone of the marker
//		until MarkerEnd() is called.  Note that class TextStream
//		actually does the heavy lifting for the TextPosnBase
//		handling of temporary markers.
//
//----------------------------------------------------------------------

package com.adobe.xfa.text;

/**
 * @exclude from published api.
 */

class MarkerTemp extends TextMarker {
	private final TextPosn moStart;
	private TextMarker mpoMarkerCopy;

	public MarkerTemp (TextPosnBase oPosn, TextMarker poSourceMarker) {
		moStart = new TextPosn (oPosn);
		moStart.position (TextPosn.POSN_BEFORE);
		mpoMarkerCopy = poSourceMarker.cloneMarker();
	}

	public TextPosn getStart () {
		return moStart;
	}

	public TextMarker getMarkerCopy () {
		return mpoMarkerCopy;
	}

	public void detach () {
		mpoMarkerCopy = null;
	}

// inherited from class TextMarker
	public TextMarker cloneMarker () {
//		JF_EX_ASSERT (false);
		return null;
	}
}
