package com.adobe.xfa.text;

/**
 * @exclude from published api.
 */

class PosnMarker extends TextPosn {
	private PosnMarker mpoMate;
	private TextMarker mpoMarker;

	PosnMarker (TextMarker poMarker) {
		mpoMate = null;
		mpoMarker = poMarker;
		position (TextPosn.POSN_BEFORE);
	}

	PosnMarker (TextPosnBase oSource, TextMarker poMarker, int ePosn) {
		super (oSource);
		mpoMate = null;
		mpoMarker = poMarker;
		setMarkerPosition (true);
		position (ePosn);
	}

	PosnMarker (TextPosnBase oSource, TextMarker poMarker) {
		this (oSource, poMarker, TextPosn.POSN_BEFORE);
	}

	PosnMarker getMate () {
		return mpoMate;
	}
	
	public boolean equals(Object object) { // NOPMD - UselessOverridingMethod - here for documentation/FindBugs suppression
		// The fields added in this derived class do not participate in equality
		return super.equals(object);
	}
	
	public int hashCode() { // NOPMD - UselessOverridingMethod - here for documentation/FindBugs suppression
		// The fields added in this derived class do not participate in equality
		return super.hashCode();
	}

	void setMate (PosnMarker poMate) {
		mpoMate = poMate;
	}

	TextMarker getMarker () {
		return mpoMarker;
	}

	void setMarker (TextMarker poMarker) {
		mpoMarker = poMarker;
	}

// This method sets the position index and then adjusts it to exclute as
// many attribute changes as possible.
	void setMarkerIndex (int nIndex) {
		index (nIndex);

// Figure out whether this is the first or only (primary) position for a
// marker or whether it's the second position for a range marker.
		boolean bPrimary = true;
		if (mpoMate != null) {
			if (mpoMate.index() == index()) {
				return;
			}
			if (mpoMate.index() < index()) {
				bPrimary = false;
			}
		}

// Primary positions should be moved ahead over any attribute changes.
		if (bPrimary) {
			tighten (true);
			if ((mpoMate != null) && (index() > mpoMate.index())) {
				index (mpoMate.index());
			}
		}

// Secondary positions should be moved back over any attribute changes.
		else {
			tighten (false);
			if (index() < mpoMate.index()) {
				index (mpoMate.index());
			}
		}
	}
}
