package com.adobe.xfa.text;

import com.adobe.xfa.text.markup.MarkupOut;

/**
 * @exclude from published api.
 */

class StrAttr extends StrItem {
	private int meState;
	private TextAttr mpoAttr;

	StrAttr () {
		super (TextItem.ATTR);
		meState = Pkg.ATTR_STATE_NORMAL;
	}

	StrAttr (TextAttr poNewAttr) {
		this (poNewAttr, null, Pkg.ATTR_STATE_NORMAL);
	}

	StrAttr (TextAttr poNewAttr, TextGfxSource poGfxSource) {
		this (poNewAttr, poGfxSource, Pkg.ATTR_STATE_NORMAL);
	}

	StrAttr (TextAttr poNewAttr, TextGfxSource poGfxSource, int eState) {
		super (TextItem.ATTR);
		meState = eState;
		connectToAttr (poNewAttr, poGfxSource);
	}

	TextAttr markup (MarkupOut oMarkup, int nStart, int nSize, boolean bFlattenFields, TextAttr poPrevAttr) {
		if (mpoAttr != null) {
			if (!oMarkup.suppressAttributes()) {
				if (poPrevAttr == null) {
					oMarkup.attr (mpoAttr);
				} else {
					TextAttr oAttr = new TextAttr (mpoAttr);
					oAttr.dropSame (poPrevAttr, false);
					oMarkup.attr (oAttr);
				}
			}

			poPrevAttr = mpoAttr;
		}

		return poPrevAttr;
	}

	TextAttr attrAt (int nIndex) {
		return mpoAttr;
	}

	boolean isEqual (StrItem poCompare) {
		if (! (poCompare instanceof StrAttr)) {	// TODO: these tests in StrFoo.IsEqual() are likely redundant
			return false;
		}
		StrAttr poStrAttr = (StrAttr) poCompare;

		if (mpoAttr == poStrAttr.mpoAttr) {
			return true; // same pointer or both null
		}

		if ((mpoAttr == null) || (poStrAttr.mpoAttr == null)) {
			return false; // only one null
		}

		return mpoAttr.equals (poStrAttr.mpoAttr);
	}

	boolean coalesce (StrItem poAfter, int nIndex) {
		StrAttr poNext = (StrAttr) poAfter;

		assert (mpoAttr != null);
		assert (poNext.mpoAttr != null);

// Because we can pass back a pointer to our text attr object that others
// may save, create a new object to hold the result.  Use reference
// counts to manage final deletion.
		TextAttr poNewAttr = new TextAttr (mpoAttr);
		poNewAttr.override (poNext.mpoAttr, null);
		mpoAttr = poNewAttr;

// Coalescing an attr with following "open": result is an open
		if (poNext.meState == Pkg.ATTR_STATE_OPEN) {
			meState = Pkg.ATTR_STATE_OPEN;
// Coalescing a "close" attr with following attr: result is a close
		} else if (meState != Pkg.ATTR_STATE_CLOSE) {
			meState = Pkg.ATTR_STATE_NORMAL;
		}

		return false;
	}

	boolean canCoalesce (StrItem poAfter) {
		StrAttr poNext = (StrAttr) poAfter;

// Can't coalesce if either is carrying a NULL pointer (should never happen)
		if ((mpoAttr == null) || (poNext.mpoAttr == null)) {
			return false;
		}
// Can't coalesce if this is a temporarily redundant open/close pair
		if ((meState == Pkg.ATTR_STATE_OPEN)
		 && (poNext.meState == Pkg.ATTR_STATE_CLOSE)
		 && (mpoAttr != (poNext.mpoAttr))) {
			return false;
		}
		return true;
	}

	StrItem cloneItem (TextGfxSource oGfxSource) {
		return new StrAttr (mpoAttr, oGfxSource, meState);
	}

	int attrState () {
		return meState;
	}

	void attrState (int eNewState) {
		meState = eNewState;
	}

	void overrideAttr (TextAttr oOverride) {
// Make a new copy because someone may be holding a pointer to the old
// one.
		if (mpoAttr != null) {
			TextAttr poNewAttr = new TextAttr (mpoAttr);
			poNewAttr.override (oOverride, null);
			mpoAttr = poNewAttr;
		}
	}

	void gfxSource (TextGfxSource oGfxSource) {
		if (mpoAttr != null) {
			if (oGfxSource != mpoAttr.gfxSource()) {
				TextAttr poOldAttr = mpoAttr;
				connectToAttr (poOldAttr, oGfxSource);
			}
		}
	}

// For debugging.
	void debug (int indent) {
		String prefix = Pkg.doIndent (indent+1);
		System.out.println (prefix + "Attribute");
		if (mpoAttr != null) {
			mpoAttr.debug();
		}
	}

	private void connectToAttr (TextAttr poNewAttr, TextGfxSource poGfxSource) {
		if (poNewAttr == null) {
			mpoAttr = new TextAttr (TextAttr.defaultAttr (false));
		} else if ((poGfxSource != null) && (poNewAttr.gfxSource() != poGfxSource)) {
			mpoAttr = new TextAttr (poNewAttr, poGfxSource);
		} else {
			mpoAttr = poNewAttr;
		}
	}
}
