package com.adobe.xfa.text;

import com.adobe.xfa.ut.FindBugsSuppress;

/**
 * @exclude from published api.
 */

public final class TextIntArray {
	public final static int MIN_ALLOC = 4;

	private int[] mArray;
	private int mSize;

	public TextIntArray () {
	}

	@FindBugsSuppress(code="EI")
	public int[] getArray () {
		return mArray;
	}

	public int getSize () {
		return mSize;
	}

	@FindBugsSuppress(code="EI")
	public int[] setSize (int size, boolean preserve) {
		allocate (size, preserve);
		mSize = size;
		return mArray;
	}

	@FindBugsSuppress(code="EI")
	public int[] setSize (int size) {
		return setSize (size, false);
	}

	private int[] allocate (int newSize, boolean preserve) {
		if ((mArray == null) || (newSize > mArray.length)) {
			int alloc = MIN_ALLOC;
			while (alloc < newSize) {
				alloc *= 2;
			}
			int[] newArray = new int [alloc];
			if (preserve && mArray != null)
				System.arraycopy(mArray, 0, newArray, 0, mSize);
			mArray = newArray;
		}
		return mArray;
	}

//	private int[] allocate (int newSize) {
//		return allocate (newSize, false);
//	}

	public int get (int index) {
		return mArray[index];
	}

	public void add (int value) {
		int index = mSize;
		setSize (mSize + 1, true);
		mArray[index] = value;
	}

	public void set (int index, int value) {
		if (index >= mSize) {
			setSize (index + 1, true);
		}
		mArray[index] = value;
	}

	public void copyFrom (TextIntArray source) {
		setSize (source.mSize);
		for (int i = 0; i < mSize; i++) {
			mArray[i] = source.mArray[i];
		}
	}
}
