package com.adobe.xfa.text;

/**
 * This is the base class for frames that support the
 * displayable stream classes.
 * @exclude from published api.
 */

abstract class TraditionalFrame extends TextFrame {
	private int mnCombCells;
	private boolean mbSuppressWordWrap;

	public TraditionalFrame () {
	}

	void setCombCells (int nCombCells) {
		mnCombCells = nCombCells;
	}

	void setSuppressWordWrap (boolean bNewSuppress) {
		mbSuppressWordWrap = bNewSuppress;
	}

	void copyFrom (TraditionalFrame oSource) {
		if (this != oSource) {
			mnCombCells = oSource.mnCombCells;
			mbSuppressWordWrap = oSource.mbSuppressWordWrap;
			super.copyFrom (oSource);
		}
	}

	public TextFrame cloneFrame () {
		assert (false);
		return null;
	}

	public int combCells () {
		return mnCombCells;
	}

	boolean allowExtension () {
		return true;
	}

	boolean suppressWordWrap () {
		return mbSuppressWordWrap;
	}
}
