/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.ut;

/**
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public class ExResourceFailure extends ExceptionBase {
	private final String msMissingFile;

	/*
	 * serialver-generated UID.
	 */
	private static final long serialVersionUID = 6307738608710413349L;
	
//	@Override
	public void resolve() {
	}

//	@Override
	public int count() {
		return 1;
	}

//	@Override
	public ExErrItem item(int nIndex) {
		ExErrItem oItem = new ExErrItem();

		String resourcefile = getMissingFile();

		// Specify English text, since language resources can't be found.
		oItem.text("Unable to locate resource file: " + resourcefile);

		return oItem;
	}

	/**
	 * Store the name of the missing resource file.
	 * @param sMissingFile name of the resource file we failed to open.
	 */
	ExResourceFailure(String sMissingFile)
	{
		msMissingFile = sMissingFile;
	}
	    

	/**
	 * return the name of the resource file we failed to load.
	 * @return resource file name.
	 */
	String getMissingFile ()
	{
	    return msMissingFile;
	}

	public String	toString() 	{
		return item(0).toString();
	}
}
