/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.ut;

/**
 * Simple class house resource ids.  In C++, ResId is a typedef to an integer.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public final class ResId {

    static public final int SVC_PA_MIN          =   0x3000; // 12288
    static public final int SVC_PA_MAX          =   0x33E8; // 13288

	static public final int SVC_TOOL_MIN		=	0x4000;	// service id minimum (16384)
	static public final int SVC_TOOL_MAX		=	0x7FFF;	// service id maximum (32767)

	static public final int SVC_NEXT			=	0x0400;	// service id increment (1024)
	static public final int SVC_NEXT_HALF		=	0x0200;	// service id increment (512)
	static public final int SVC_NEXT_QURT		=	0x0100;	// service id increment (256)
	static public final int SVC_NEXT_BIT		=	0x0080;	// service id increment (128)

	/**
	 * Service id bases beginning with SVC_FREE are available for reuse, but
	 * do use bases and especially increments, judiciously...  The other SVC
	 * bases are fixed, and shouldn't be moved.  But there are plenty of resource
	 * id ranges available between these.
	 */
	static public final int SVC_PA			    =	(SVC_PA_MIN);								// 0x3000
	static public final int SVC_UTILITY			=	(SVC_TOOL_MIN);								// 0x4000
	static public final int SVC_GRAPHIC			=	(SVC_UTILITY 			+ SVC_NEXT);		// 0x4400
	static public final int SVC_TEXT 			=	(SVC_GRAPHIC 			+ SVC_NEXT);		// 0x4800
	static public final int SVC_SCHEMA			=	(SVC_TEXT				+ SVC_NEXT);		// 0x4C00
	static public final int SVC_WSDL 			=	(SVC_SCHEMA				+ SVC_NEXT_HALF); 	// 0x4E00
	static public final int SVC_SOAP 			=	(SVC_WSDL				+ SVC_NEXT_QURT); 	// 0x4F00
	static public final int SVC_FONT			=	(SVC_SOAP				+ SVC_NEXT_QURT); 	// 0x5000
	static public final int SVC_XFA_FORM 		=	(SVC_FONT				+ SVC_NEXT);		// 0x5400
	static public final int SVC_XFA_CONNECTIONSET=	(SVC_XFA_FORM			+ SVC_NEXT_QURT); 	// 0x5500
	static public final int SVC_XFA_PLUGIN		=	(SVC_XFA_CONNECTIONSET	+ SVC_NEXT_BIT);	// 0x5580
	static public final int SVC_XFA_FONT		=	(SVC_XFA_PLUGIN			+ SVC_NEXT_BIT);	// 0x5600
	static public final int SVC_IMPORT			=	(SVC_XFA_FONT			+ SVC_NEXT_HALF);	// 0x5800
	static public final int SVC_FREE_C2			=	(SVC_IMPORT				+ SVC_NEXT);		// 0x5C00
	static public final int SVC_FREE_C3			=	(SVC_FREE_C2 			+ SVC_NEXT);		// 0x6000
	static public final int SVC_FREE_D			=	(SVC_FREE_C3 			+ SVC_NEXT);		// 0x6400
	static public final int SVC_FREE_E			=	(SVC_FREE_D				+ SVC_NEXT);		// 0x6800
	static public final int SVC_FREE_F			=	(SVC_FREE_E				+ SVC_NEXT);		// 0x6C00
	static public final int SVC_FREE_G			=	(SVC_FREE_F				+ SVC_NEXT);		// 0x7000
	static public final int SVC_XFA				=	(SVC_FREE_G				+ SVC_NEXT_HALF);	// 0x7200
	static public final int SVC_PROTOCOL 		=	(SVC_XFA 				+ SVC_NEXT_HALF);	// 0x7400
	static public final int SVC_DOM				=	(SVC_PROTOCOL			+ SVC_NEXT_HALF);	// 0x7600
	static public final int SVC_FC				=	(SVC_DOM 				+ SVC_NEXT_HALF);	// 0x7800
	static public final int SVC_XFA_LOCALESET	=	(SVC_FC					+ SVC_NEXT_QURT);	// 0x7900
	static public final int SVC_XFA_XDC			=	(SVC_XFA_LOCALESET		+ SVC_NEXT_QURT);	// 0x7A00
	static public final int SVC_XFA_LAYOUT		=	(SVC_XFA_XDC 			+ SVC_NEXT_QURT);	// 0x7B00
	static public final int SVC_XFA_TEMPLATE 	=	(SVC_XFA_LAYOUT			+ SVC_NEXT_QURT);	// 0x7C00
	static public final int SVC_XFA_CONFIGURATION=	(SVC_XFA_TEMPLATE		+ SVC_NEXT_QURT);	// 0x7D00
	static public final int SVC_XFA_SOURCESET	=	(SVC_XFA_CONFIGURATION	+ SVC_NEXT_QURT);	// 0x7F00
	/* DO NOT ADD MORE BASES HERE!	We're at the maximum!  */
	/* The last resource id cannot exceed SVC_TOOL_MAX! */
	/* Use one of the free spots instead.				   */

	/**
	 * Functions, macros for construction of resource Id's and object types.
	 * The two are constructed in the same way, but may change in the future.
	 * The macros exist for resource compilers.
	 */

	static int MAKE_RES_ID(int iSvc, int iCode) {
		return ((iSvc) + (iCode));
	}

	static int MakeResId (int iSvc, int iCode) {
		return MAKE_RES_ID (iSvc, iCode);
	}

// Resources from pa_res.h
	public static final int CredentialsNotFound    = MAKE_RES_ID(SVC_PA, 374);
	public static final int SoapFaultReported      = MAKE_RES_ID(SVC_PA, 375);

	
// Resources from uts_res.h

//
//	 General utility resource codes
//
//	 (suggest range 0-99)

	// 80

	public static final int CODE_PAGE_NOT_SUPPORTED	= MAKE_RES_ID (SVC_UTILITY, 81);

	public static final int SOFTWARE_FAILURE		= MAKE_RES_ID (SVC_UTILITY, 95);
	public static final int UNSUPPORTED_OPERATION	= MAKE_RES_ID (SVC_UTILITY, 96);

//	 99

//
//	 Base class resource codes
//
//	 (suggest range 100-199);


//	 Class jfExMemory
	public static final int ERR_ALLOC				= MAKE_RES_ID (SVC_UTILITY, 199);


//
//	 File class resource codes
//
//	 (suggest range 200-399);

//	 Class jfFile
	public static final int FILE_ERR_CLOSE			= MAKE_RES_ID (SVC_UTILITY, 200);
	public static final int FILE_ERR_OPEN			= MAKE_RES_ID (SVC_UTILITY, 201);
//	 202
	public static final int FILE_ERR_MUST_EXIST		= MAKE_RES_ID (SVC_UTILITY, 203);
	public static final int FILE_ERR_MUST_NOT_EXIST	= MAKE_RES_ID (SVC_UTILITY, 204);
	public static final int FILE_ERR_NO_FILEID		= MAKE_RES_ID (SVC_UTILITY, 205);

//	 Class jfStreamFile
//	 Class jfPropertySet
	public static final int STREAMFILE_ERR_FLUSH 	= MAKE_RES_ID (SVC_UTILITY, 260);
	public static final int STREAMFILE_ERR_SEEK		= MAKE_RES_ID (SVC_UTILITY, 261);
	public static final int FILE_ERR_READING_OUTFIL	= MAKE_RES_ID (SVC_UTILITY, 262);
	public static final int FILE_ERR_WRITING_INFIL	= MAKE_RES_ID (SVC_UTILITY, 263);
	public static final int STREAMFILE_ERR_WRITE 	= MAKE_RES_ID (SVC_UTILITY, 264);
	public static final int STREAMFILE_ERR_READ		= MAKE_RES_ID (SVC_UTILITY, 265);
	public static final int STREAMFILE_ERR_TRUNC 	= MAKE_RES_ID (SVC_UTILITY, 266);
	public static final int STREAMFILE_ERR_EOF		= MAKE_RES_ID (SVC_UTILITY, 267);
	public static final int STREAMFILE_INFO_NAME 	= MAKE_RES_ID (SVC_UTILITY, 268);
	public static final int STREAMFILE_ERR_CHANGESIZE = MAKE_RES_ID (SVC_UTILITY, 269);
//	270
	public static final int STREAM_PROTOCOL_NOT_AVAIL = MAKE_RES_ID (SVC_UTILITY, 270);
	public static final int STDIOSTR_ERR_SYSTEM		= MAKE_RES_ID (SVC_UTILITY, 271);
	public static final int STREAM_IMPL_NOT_AVAIL	= MAKE_RES_ID (SVC_UTILITY, 272);

	public static final int STREAMFILE_ERR_UNSUPPORTED_CHARCONV	= MAKE_RES_ID (SVC_UTILITY, 277);


	public static final int FILEIDIMPL_ERR_DELETE	= MAKE_RES_ID (SVC_UTILITY, 364);
	public static final int FILEIDIMPL_ERR_RENAME	= MAKE_RES_ID (SVC_UTILITY, 365);
	public static final int FILEIDIMPL_ERR_TEMPNAME  = MAKE_RES_ID (SVC_UTILITY, 366);

	public static final int FILEIDIMPL_ERR_COPY		= MAKE_RES_ID (SVC_UTILITY, 369);

	public static final int UTS_ERR_MKDIR			= MAKE_RES_ID (SVC_UTILITY, 374);
	public static final int UTS_ERR_RMDIR			= MAKE_RES_ID (SVC_UTILITY, 375);
	public static final int FILEID_ERR_FILEATTR		= MAKE_RES_ID (SVC_UTILITY, 376);
	public static final int FILEID_ERR_GETTEMPDIR	= MAKE_RES_ID (SVC_UTILITY, 377);


	public static final int ILLEGAL_BASE64_ENCODING	= MAKE_RES_ID (SVC_UTILITY, 393);

	public static final int IndexOutOfBoundsException	= MAKE_RES_ID(SVC_UTILITY, 600);
	public static final int ObjectNotFoundException = MAKE_RES_ID (SVC_UTILITY, 603);

//	/ Class jfUnitSpan
	public static final int ERR_UNITSPAN_UNITS		= MAKE_RES_ID (SVC_UTILITY, 723);

//	 Class jfAngle
	public static final int ANGLE_ERR_RANGE			= MAKE_RES_ID (SVC_UTILITY, 790);

	//
//	 Date/time class resource codes
	//
//	 (suggest range 800-899);
	public static final int DATE_INVALID_YEAR		= MAKE_RES_ID (SVC_UTILITY, 801);
	public static final int DATE_INVALID_MONTH		= MAKE_RES_ID (SVC_UTILITY, 802);
	public static final int DATE_INVALID_DAY 		= MAKE_RES_ID (SVC_UTILITY, 803);
	public static final int DATE_PARSE_FAILED		= MAKE_RES_ID (SVC_UTILITY, 804);

	public static final int TIME_INVALID_HOUR		= MAKE_RES_ID (SVC_UTILITY, 850);
	public static final int TIME_INVALID_MINUTE		= MAKE_RES_ID (SVC_UTILITY, 851);
	public static final int TIME_INVALID_SECOND		= MAKE_RES_ID (SVC_UTILITY, 852);
	public static final int TIME_INVALID_MILLISEC	= MAKE_RES_ID (SVC_UTILITY, 853);

	public static final int TIME_AM					= MAKE_RES_ID (SVC_UTILITY, 860);
	public static final int TIME_PM					= MAKE_RES_ID (SVC_UTILITY, 861);


//	Resources from text_res.h
	public static final int InvalidInputObject		= MAKE_RES_ID(SVC_TEXT, 17);

//	Resources from xfaplugin
	public static final int LAUNCH_MONITOR						= MAKE_RES_ID( SVC_XFA_PLUGIN, 0 );
	public static final int INVALID_DIGEST_METHOD				= MAKE_RES_ID( SVC_XFA_PLUGIN, 1 );
	public static final int INVALID_SIGNATURE_METHOD			= MAKE_RES_ID( SVC_XFA_PLUGIN, 2 );
	public static final int MACSIG_SUPPORT_ERROR				= MAKE_RES_ID( SVC_XFA_PLUGIN, 3 );
	public static final int OPERATION_CANCELLED					= MAKE_RES_ID( SVC_XFA_PLUGIN, 4 );
	public static final int SCRIPT_EXCEPTION					= MAKE_RES_ID( SVC_XFA_PLUGIN, 5 );
	public static final int SAVEXDP_EXCEPTION					= MAKE_RES_ID( SVC_XFA_PLUGIN, 6 );
	public static final int LOADXDP_EXCEPTION					= MAKE_RES_ID( SVC_XFA_PLUGIN, 7 );
	public static final int VALIDATE_FAILED						= MAKE_RES_ID( SVC_XFA_PLUGIN, 8 );
	public static final int VALIDATE_NULLTEST_FAILED			= MAKE_RES_ID( SVC_XFA_PLUGIN, 9 );
	public static final int SUBMIT_EENVELOPE					= MAKE_RES_ID( SVC_XFA_PLUGIN, 10 );
	public static final int ACROFORM_SAVE_ERROR					= MAKE_RES_ID( SVC_XFA_PLUGIN, 11 );
	public static final int VALIDATE_WARNING_MESSAGE			= MAKE_RES_ID( SVC_XFA_PLUGIN, 12 );
	public static final int VALIDATE_WARNING_MESSAGE_NULLTEST	= MAKE_RES_ID( SVC_XFA_PLUGIN, 13 );
	public static final int VALIDATE_WARNING_SUGGESTION			= MAKE_RES_ID( SVC_XFA_PLUGIN, 14 );
	public static final int UNTRUSTED_CONNECTION_EXCEPTION		= MAKE_RES_ID( SVC_XFA_PLUGIN, 15 );

// Resources from xfa_res.h
	public static final int InvalidSOMException				= MAKE_RES_ID (SVC_XFA, 0 );
	public static final int SOMTypeException				= MAKE_RES_ID (SVC_XFA, 1 );
	public static final int SOMEmptyResultException			= MAKE_RES_ID (SVC_XFA, 2 );
	public static final int InvalidGetPropertyException		= MAKE_RES_ID (SVC_XFA, 3 );
	public static final int NoDefaultGetPropertyException	= MAKE_RES_ID (SVC_XFA, 4 );
	public static final int InvalidSetPropertyException		= MAKE_RES_ID (SVC_XFA, 5 );
	public static final int NoDefaultSetPropertyException	= MAKE_RES_ID (SVC_XFA, 6 );
	public static final int InvalidMethodException			= MAKE_RES_ID (SVC_XFA, 7 );
	public static final int NoDefaultMethodException		= MAKE_RES_ID (SVC_XFA, 8 );
	public static final int BadParamCountException			= MAKE_RES_ID (SVC_XFA, 9 );
	public static final int ArgumentMismatchException		= MAKE_RES_ID (SVC_XFA, 10 );
	public static final int HierarchyRequestException		= MAKE_RES_ID (SVC_XFA, 11 );
	public static final int InsertFailedException			= MAKE_RES_ID (SVC_XFA, 12 );
	public static final int RemoveFailedException			= MAKE_RES_ID (SVC_XFA, 13 );
	public static final int SOMPropertyReturnedException	= MAKE_RES_ID (SVC_XFA, 14 );
	public static final int InvalidDataSourceException		= MAKE_RES_ID (SVC_XFA, 15 );
	public static final int CantSetContentType				= MAKE_RES_ID (SVC_XFA, 16 );
	public static final int InvalidDATFile					= MAKE_RES_ID (SVC_XFA, 17 );
	public static final int UnsupportedOperationException   = MAKE_RES_ID (SVC_XFA, 18 );
	public static final int InvalidNodeTypeException		= MAKE_RES_ID (SVC_XFA, 19 );
	public static final int InvalidOptionException			= MAKE_RES_ID (SVC_XFA, 20 );
	public static final int OptionWrongPackageException		= MAKE_RES_ID (SVC_XFA, 21 );
	public static final int MalformedOptionException		= MAKE_RES_ID (SVC_XFA, 22 );
	public static final int UnqualifiedOptionException		= MAKE_RES_ID (SVC_XFA, 23 );
	public static final int OptionMisuseException			= MAKE_RES_ID (SVC_XFA, 24 );
	public static final int OptionLockedException			= MAKE_RES_ID (SVC_XFA, 25 );
	public static final int InvalidOptionValueException		= MAKE_RES_ID (SVC_XFA, 26 );
	public static final int OutsideDataWindowException		= MAKE_RES_ID (SVC_XFA, 27 );
	public static final int InvalidRecordException			= MAKE_RES_ID (SVC_XFA, 28 );
	public static final int CantFindRecordException			= MAKE_RES_ID (SVC_XFA, 29 );
	public static final int RecordInvalidAfterXSL			= MAKE_RES_ID (SVC_XFA, 30 );
	public static final int UndefinedDataWindowException	= MAKE_RES_ID (SVC_XFA, 31 );
	public static final int InvalidPropertyValueException	= MAKE_RES_ID (SVC_XFA, 32 );
	public static final int FoundBadAttributeException		= MAKE_RES_ID (SVC_XFA, 33 );
	public static final int ParentChildViolationException   = MAKE_RES_ID (SVC_XFA, 34 );
	public static final int InvalidChildAppendException		= MAKE_RES_ID (SVC_XFA, 35 );
	public static final int InvalidChildInsertException		= MAKE_RES_ID (SVC_XFA, 36 );
	public static final int ImmutableAttributeException		= MAKE_RES_ID (SVC_XFA, 37 );
	public static final int InvalidAttributeException		= MAKE_RES_ID (SVC_XFA, 38 );
	public static final int NamelessNodeInGetSOMException	= MAKE_RES_ID (SVC_XFA, 39 );
	public static final int InvalidGetOneOfException		= MAKE_RES_ID (SVC_XFA, 40 );
	public static final int InvalidSetOneOfException		= MAKE_RES_ID (SVC_XFA, 41 );
	public static final int InvalidAttributeLoadException	= MAKE_RES_ID (SVC_XFA, 42 );
	public static final int NodeAlreadyExistException		= MAKE_RES_ID (SVC_XFA, 43 );
	public static final int NoNameException					= MAKE_RES_ID (SVC_XFA, 44 );
	public static final int InvalidFieldSignatureChildLoadException	= MAKE_RES_ID (SVC_XFA, 45 );

//	xmltrans
	public static final int InvalidConfigFile				= MAKE_RES_ID (SVC_XFA, 46 );
	public static final int ConfigFileNotFound				= MAKE_RES_ID (SVC_XFA, 47 );
//	xfatemplate, formatting

//	 CoretechLib tracing
	public static final int CoretechBIBClientInitTrace				= MAKE_RES_ID (SVC_XFA, 48 );
	public static final int CoretechBIBClientTermTrace				= MAKE_RES_ID (SVC_XFA, 49 );
	public static final int CoretechInitParamTrace					= MAKE_RES_ID (SVC_XFA, 50 );
	public static final int CoretechCTInitTrace						= MAKE_RES_ID (SVC_XFA, 51 );

//	 General tracing
	public static final int GeneralTraceHelp						= MAKE_RES_ID (SVC_XFA, 52);

//	 Font service tracing
	public static final int FontTraceHelp							= MAKE_RES_ID (SVC_XFA, 53);

//	 pdlFileCache tracing
	public static final int PDLFileCacheTraceHelp					= MAKE_RES_ID (SVC_XFA, 54);

//	xfatemplate, formatting
	public static final int ParseCharWidthException					= MAKE_RES_ID (SVC_XFA, 55 );
	public static final int LogContent								= MAKE_RES_ID (SVC_XFA, 56 );
	public static final int LogToValueNotSpecified					= MAKE_RES_ID (SVC_XFA, 57 );
	public static final int LogUriValueNotSpecified					= MAKE_RES_ID (SVC_XFA, 58 );

//	 XFASourceSet tracing
	public static final int SourceSetTraceHelp						= MAKE_RES_ID (SVC_XFA, 59);

//	xfatemplate, formatting again
	public static final int MissingLogInfoException					= MAKE_RES_ID (SVC_XFA, 60 );
	public static final int InvalidCommandlineOption				= MAKE_RES_ID (SVC_XFA, 61 );
	public static final int CommandlineHelpOption					= MAKE_RES_ID (SVC_XFA, 62 );
	public static final int CommandlineHelpConfigOption				= MAKE_RES_ID (SVC_XFA, 63 );

//	 XFASoureSet tracing
	public static final int ADOConnectionCreateTrace				= MAKE_RES_ID (SVC_XFA, 64);
	public static final int ADOReturnTrace							= MAKE_RES_ID (SVC_XFA, 65);

	public static final int XFAConfigPrintAttrPa					= MAKE_RES_ID (SVC_XFA, 66 );
	public static final int XFAConfigPrintAttrTp					= MAKE_RES_ID (SVC_XFA, 67 );
	public static final int InvalidPropertyException				= MAKE_RES_ID (SVC_XFA, 68 );

//	 More XFASourceSet tracing
	public static final int ADOConnectionCursorLocationTrace        = MAKE_RES_ID (SVC_XFA, 69);

	public static final int XFAConfigPrintCmmntCommonUri			= MAKE_RES_ID (SVC_XFA, 70 );

//	 XFASourseSet tracing again
	public static final int ADOConnectionOpenTrace					= MAKE_RES_ID (SVC_XFA, 71);
	public static final int ADOConnectionCloseTrace					= MAKE_RES_ID (SVC_XFA, 72);
	public static final int ADOConnectionGetStateTrace				= MAKE_RES_ID (SVC_XFA, 73);
	public static final int ADORecordSetTrace						= MAKE_RES_ID (SVC_XFA, 74);
	public static final int ADORecordSetOpenTrace					= MAKE_RES_ID (SVC_XFA, 75);

	public static final int ScriptTraceReturnValue					= MAKE_RES_ID (SVC_XFA, 76 );
	public static final int XFAConfigPrintCmmntPaDestination		= MAKE_RES_ID (SVC_XFA, 77 );
	public static final int XFAConfigPrintCmmntPaDestinationUnknown	= MAKE_RES_ID (SVC_XFA, 78 );

//	 overlayData
	public static final int OverlayDataSubformNotFound				= MAKE_RES_ID (SVC_XFA, 79 );

	public static final int XFAConfigPrintCmmntCompressionLevel		= MAKE_RES_ID (SVC_XFA, 80 );
	public static final int XFAConfigPrintCmmntPdfVersion			= MAKE_RES_ID (SVC_XFA, 81 );
	public static final int XFAConfigPrintCmmntFontMapEquate		= MAKE_RES_ID (SVC_XFA, 82 );
	public static final int InvalidLogDirectoryException			= MAKE_RES_ID (SVC_XFA, 83 );
	public static final int InvalidOverrideOperationException		= MAKE_RES_ID (SVC_XFA, 84 );
	public static final int XFAConfigPrintCmmntTraceArea			= MAKE_RES_ID (SVC_XFA, 85 );

// 	Barcode validation, XFAForm
	public static final int InvalidBarcodeValue						= MAKE_RES_ID (SVC_XFA, 86 );

//	xfa core again
	public static final int UnknownScriptLanguageException			= MAKE_RES_ID (SVC_XFA, 87 );
	public static final int DuplicateModelLoadException				= MAKE_RES_ID (SVC_XFA, 88 );

//	 Resources for XFADataValueImpl
	public static final int InvalidParentNode						= MAKE_RES_ID (SVC_XFA, 89 );
	public static final int NodeHasChildren							= MAKE_RES_ID (SVC_XFA, 90 );
	public static final int InvalidName								= MAKE_RES_ID (SVC_XFA, 91 );

// 	Barcode validation, XFAForm
	public static final int NullBarcodeValue						= MAKE_RES_ID (SVC_XFA, 92 );

//	 New element for compression in configuration
	public static final int XFAConfigPrintCmmntSubsetBelow			= MAKE_RES_ID (SVC_XFA, 93 );
	public static final int XFAConfigPrintCmmntCompressionTypeTiff	= MAKE_RES_ID (SVC_XFA, 94 );
	public static final int XFAConfigPrintCmmntcSpace				= MAKE_RES_ID (SVC_XFA, 95 );

//	 Content verification in XFAExData
	public static final int UnsupportedContentWarning				= MAKE_RES_ID (SVC_XFA, 96 );

//	xfa core
	public static final int DataFileNotFound						= MAKE_RES_ID (SVC_XFA, 97 );

//	 xfa trace
	public static final int CommandlineHelpTraceOption				= MAKE_RES_ID (SVC_XFA, 98 );

//	 xfa core
	public static final int InvalidEnumeratedValue					= MAKE_RES_ID (SVC_XFA, 99);

//	xmlfm
	public static final int IncorrectFontLocationSetting			= MAKE_RES_ID (SVC_XFA, 100 );

// xfa core
	public static final int ScriptTraceExecute						= MAKE_RES_ID (SVC_XFA, 101 );

//	 xfa agent
	public static final int XFAAgentBanner							= MAKE_RES_ID (SVC_XFA, 102 );
	public static final int XFAAgentUsage							= MAKE_RES_ID (SVC_XFA, 103 );
	public static final int XFAAgentSuccess							= MAKE_RES_ID (SVC_XFA, 104 );
	public static final int XFAAgentFailure							= MAKE_RES_ID (SVC_XFA, 105 );
	public static final int CommandlineHelpTraceMsg					= MAKE_RES_ID (SVC_XFA, 106 );

//	 xfa version
	public static final int CommandlineHelpVersionOption			= MAKE_RES_ID (SVC_XFA, 107 );

//	 xfa core
	public static final int ScriptFailure							= MAKE_RES_ID (SVC_XFA, 108 );

//	 xfa agent
	public static final int XFAAgentBadTempDir						= MAKE_RES_ID (SVC_XFA, 109 );

//	 xfa core
	public static final int ClassNotInitialized						= MAKE_RES_ID (SVC_XFA, 110 );
	public static final int SearchNonNodeSOMException				= MAKE_RES_ID (SVC_XFA, 111 );

	public static final int ScriptTraceHelp							= MAKE_RES_ID (SVC_XFA, 112 );
	public static final int MergeTraceHelp							= MAKE_RES_ID (SVC_XFA, 113 );

//	 xfa merge trace
	public static final int StartMergeDataGroup						= MAKE_RES_ID (SVC_XFA, 114 );
	public static final int NodeCreatedTrace						= MAKE_RES_ID (SVC_XFA,	115 );
	public static final int FormNodeMatchedTrace					= MAKE_RES_ID (SVC_XFA, 116 );
	public static final int DataNodeMoved							= MAKE_RES_ID (SVC_XFA, 117 );
	public static final int NodeComparedTrace						= MAKE_RES_ID (SVC_XFA, 118 );

	public static final int SOMRefPropertyException					= MAKE_RES_ID (SVC_XFA, 119 );
	
//	xfa config
	public static final int FoundBadElementValueException			= MAKE_RES_ID (SVC_XFA, 120 );
	
	public static final int EmptySOMResult							= MAKE_RES_ID (SVC_XFA, 121 );

//	 xdc
	public static final int InvalidVarNameException					= MAKE_RES_ID(SVC_XFA, 122);
	public static final int CreateVarNameException					= MAKE_RES_ID(SVC_XFA, 123);
	
// XMLFormAgent
	public static final int FailedToCollectResourceInfo				= MAKE_RES_ID(SVC_XFA, 124);
	
//	xdc
	public static final int FontNotFoundInXDC						= MAKE_RES_ID(SVC_XFA, 125);
	
// XMLFormAgent
	public static final int FailedToAssignValue						= MAKE_RES_ID(SVC_XFA, 126);
	public static final int IllegalPrintBatchFormat					= MAKE_RES_ID(SVC_XFA, 127);
	public static final int IllegalRenderPolicySetting				= MAKE_RES_ID(SVC_XFA, 128);

//	xdc
	public static final int InvalidXDCControlCodeException			= MAKE_RES_ID(SVC_XFA, 129);
	public static final int ByteStreamTraceVarSet					= MAKE_RES_ID(SVC_XFA, 130);
	public static final int ByteStreamTraceVarSeq					= MAKE_RES_ID(SVC_XFA, 131);

//	 xfa merge trace
	public static final int	UnmappedNode							= MAKE_RES_ID(SVC_XFA, 132);

//	 XFATemplate
	public static final int MediumNotResolved						= MAKE_RES_ID(SVC_XFA, 133);

//	 XFAMergeSvc
	public static final int XFAAddInstanceRecursiveException		= MAKE_RES_ID (SVC_XFA, 134 );
	public static final int IncompatibleContentType					= MAKE_RES_ID (SVC_XFA, 135 );

	public static final int CantCreateSOMExpression					= MAKE_RES_ID (SVC_XFA, 136 );

//	 Error reporting during model loads
	public static final int XMLFileLineNumberLoadException			= MAKE_RES_ID (SVC_XFA, 137 );
	public static final int XMLFileLoadException					= MAKE_RES_ID (SVC_XFA, 138 );
	public static final int XMLLineNumberLoadException				= MAKE_RES_ID (SVC_XFA, 139 );

//	XFATemplate
	public static final int OccurrenceViolationException			= MAKE_RES_ID (SVC_XFA, 140 );

//	 xdc
	public static final int ByteStreamTraceVarAppend				= MAKE_RES_ID(SVC_XFA, 141);
	public static final int XDCVarBinaryValue						= MAKE_RES_ID(SVC_XFA, 142);
	public static final int XDCVarAlreadyAdded						= MAKE_RES_ID(SVC_XFA, 143);

//	 xfa core
	public static final int TraceEventOccurred						= MAKE_RES_ID (SVC_XFA, 144);

//	xfa layout
	public static final int LayoutTraceDesc							= MAKE_RES_ID(SVC_XFA, 145);
	public static final int LayoutResolvePreBreakTrace				= MAKE_RES_ID(SVC_XFA, 146);
	public static final int LayoutResolvePostBreakTrace				= MAKE_RES_ID(SVC_XFA, 147);
	public static final int LayoutNodeStartPositionalTrace			= MAKE_RES_ID(SVC_XFA, 148);
	public static final int LayoutNodeEndTrace						= MAKE_RES_ID(SVC_XFA, 149);
	public static final int LayoutNodeStartFlowTrace				= MAKE_RES_ID(SVC_XFA, 150);
	public static final int LayoutNodeStartRowTrace					= MAKE_RES_ID(SVC_XFA, 151);
	public static final int LayoutUnknownRelation					= MAKE_RES_ID(SVC_XFA, 152);
	public static final int LayoutLastPageBacktrackSuccessTrace		= MAKE_RES_ID(SVC_XFA, 153);
	
//	xmlformagent
	public static final int OutputTypeNotSupported					= MAKE_RES_ID(SVC_XFA, 154);
	public static final int SignatureNotPreserved					= MAKE_RES_ID(SVC_XFA, 155);
	
//	xfa layout
	public static final int LayoutUnsupportedForcedPageBreak		= MAKE_RES_ID(SVC_XFA, 156);
	public static final int LayoutNodeOverflowTrace					= MAKE_RES_ID(SVC_XFA, 157);
	public static final int LayoutNewContentAreaTrace				= MAKE_RES_ID(SVC_XFA, 158);
	public static final int LayoutNewPageTrace						= MAKE_RES_ID(SVC_XFA, 159);
	public static final int LayoutUnknownPageTrace					= MAKE_RES_ID(SVC_XFA, 160);
	public static final int LayoutNoPageSpecifiedTrace				= MAKE_RES_ID(SVC_XFA, 161);
	public static final int LayoutInvalidPageSetRelation			= MAKE_RES_ID(SVC_XFA, 162);
	public static final int LayoutNoTrailersTrace					= MAKE_RES_ID(SVC_XFA, 163);
	public static final int LayoutNoLeadersTrace					= MAKE_RES_ID(SVC_XFA, 164);
	public static final int LayoutInvalidBreak						= MAKE_RES_ID(SVC_XFA, 165);
	public static final int LayoutInvalidLayout						= MAKE_RES_ID(SVC_XFA, 166);
	public static final int LayoutNoPageSetFound					= MAKE_RES_ID(SVC_XFA, 167);
	public static final int LayoutUnknownTargetTrace				= MAKE_RES_ID(SVC_XFA, 168);
	public static final int LayoutUnknownContentAreaTrace			= MAKE_RES_ID(SVC_XFA, 169);

//	xfa template
	public static final int XFAGlobalFieldConflictException			= MAKE_RES_ID(SVC_XFA, 170);
	public static final int XFAMoveInstanceException				= MAKE_RES_ID(SVC_XFA, 171);

//	 xfa sourceset
	public static final int XFASourceMethodException				= MAKE_RES_ID(SVC_XFA, 172);
	public static final int XFASourceNullConnectionException		= MAKE_RES_ID(SVC_XFA, 173);
	public static final int XFASourceCOMCreationException			= MAKE_RES_ID(SVC_XFA, 174);
	public static final int XFASourceUnsupportedOperationException	= MAKE_RES_ID(SVC_XFA, 175);
	public static final int XFASourceNoRecordsException				= MAKE_RES_ID(SVC_XFA, 176);

//	XFADataValueImpl
	public static final int ConflictingDataPictureException			= MAKE_RES_ID(SVC_XFA, 177);

//	signature
	public static final int TransientNodeSignatureException			= MAKE_RES_ID(SVC_XFA, 178);
	public static final int FormSignCancelled						= MAKE_RES_ID(SVC_XFA, 179);

//	xfa layout
	public static final int InconsistentNumericSymbolException		= MAKE_RES_ID(SVC_XFA, 180);

//	XFAFormFieldImpl
	public static final int OverwriteSignatureException				= MAKE_RES_ID(SVC_XFA, 181);
	public static final int NoPKISignatureException					= MAKE_RES_ID(SVC_XFA, 182);
	public static final int NonSignatureFieldException				= MAKE_RES_ID(SVC_XFA, 183);
	public static final int NoManifestSignatureException			= MAKE_RES_ID(SVC_XFA, 184);
	public static final int DataBindingSignatureException			= MAKE_RES_ID(SVC_XFA, 185);

//	XFAAgent
	public static final int XSLFileNotFound							= MAKE_RES_ID(SVC_XFA, 186);

//	xfa layout
	public static final int	LayoutEndOfPagesException				= MAKE_RES_ID(SVC_XFA, 187);
	public static final int LayoutNoRootSubformFound				= MAKE_RES_ID(SVC_XFA, 188);
	public static final int LayoutInfiniteBoilerPlatePageArea		= MAKE_RES_ID(SVC_XFA, 189);
	public static final int LayoutNewBoilerplatePageTrace			= MAKE_RES_ID(SVC_XFA, 190);

//	XFAForm
	public static final int RootSubformMergeFailure					= MAKE_RES_ID(SVC_XFA, 191);

//	xfa layout
	public static final int LayoutRootSubformInvalidLayout			= MAKE_RES_ID(SVC_XFA, 192);
	public static final int LayoutIncrementalLayoutFailed			= MAKE_RES_ID(SVC_XFA, 193);
	public static final int LayoutUnknownPagesetRelation			= MAKE_RES_ID(SVC_XFA, 194);

//	 xfa rendering agent
//	194
	public static final int GeneralTraceLoadDom						= MAKE_RES_ID(SVC_XFA, 195);
	public static final int GeneralTraceMerge						= MAKE_RES_ID(SVC_XFA, 196);
	public static final int GeneralTraceLayout						= MAKE_RES_ID(SVC_XFA, 197);
	public static final int GeneralTraceRender						= MAKE_RES_ID(SVC_XFA, 198);
	public static final int GeneralTraceMemory						= MAKE_RES_ID(SVC_XFA, 199);
//	200
	public static final int BIBInitializeException					= MAKE_RES_ID(SVC_XFA, 201);
	public static final int AGMInitializeException					= MAKE_RES_ID(SVC_XFA, 202);
	public static final int CoolTypeInitializeException				= MAKE_RES_ID(SVC_XFA, 203);
	public static final int ACEInitializeException					= MAKE_RES_ID(SVC_XFA, 204);
	public static final int OPPInitializeException					= MAKE_RES_ID(SVC_XFA, 205);
	public static final int PDFLInitializeException					= MAKE_RES_ID(SVC_XFA, 206);

	public static final int DestinationNotSpecifiedError			= MAKE_RES_ID(SVC_XFA, 207);
	public static final int XDCFileNotFound							= MAKE_RES_ID(SVC_XFA, 208);
	public static final int TemplateFileNotFound					= MAKE_RES_ID(SVC_XFA, 209);
	public static final int SourceSetFileNotFound					= MAKE_RES_ID(SVC_XFA, 210);
	public static final int XDPFileNotFound							= MAKE_RES_ID(SVC_XFA, 211);

	public static final int ConfigFileNotSpecified					= MAKE_RES_ID(SVC_XFA, 212);
	public static final int DataFileNotSpecified					= MAKE_RES_ID(SVC_XFA, 213);
	public static final int XDCFileNotSpecified						= MAKE_RES_ID(SVC_XFA, 214);
	public static final int TemplateFileNotSpecified				= MAKE_RES_ID(SVC_XFA, 215);
	public static final int SourceSetFileNotSpecified				= MAKE_RES_ID(SVC_XFA, 216);
	public static final int XDPFileNotSpecified						= MAKE_RES_ID(SVC_XFA, 217);
	public static final int OutputToNotSpecifiedError				= MAKE_RES_ID(SVC_XFA, 218);
	public static final int UnknownOutputFormatError				= MAKE_RES_ID(SVC_XFA, 219);
	public static final int InvalidOutputStreamError				= MAKE_RES_ID(SVC_XFA, 220);

	public static final int XFASourceUntrustedConnectionException	= MAKE_RES_ID(SVC_XFA, 221);

	public static final int LayoutIncrementalLayoutPassed			= MAKE_RES_ID(SVC_XFA, 222);
	public static final int LayoutInvalidIDSyntax					= MAKE_RES_ID(SVC_XFA, 223);
	public static final int LayoutInvalidNodeType					= MAKE_RES_ID(SVC_XFA, 224);

//	 xfa agent
	public static final int XFAAgentInvalidOption					= MAKE_RES_ID (SVC_XFA, 225 );
	public static final int XFAAgentWrongFileType					= MAKE_RES_ID (SVC_XFA, 226 );

//	xfa layout
	public static final int LayoutRegisterPseudoModelException		= MAKE_RES_ID (SVC_XFA, 227 );
	public static final int LayoutUnsupportedXFAEmbedObj			= MAKE_RES_ID (SVC_XFA, 228 );

//	 XDP Toolkit (formerly turncoat);
	public static final int PDFL_Error								= MAKE_RES_ID (SVC_XFA, 229 );
	public static final int XDPTK_Invalid_PDF						= MAKE_RES_ID (SVC_XFA, 230 );
	public static final int XDPTK_No_Embedded_PDF					= MAKE_RES_ID (SVC_XFA, 231 );

//	 Used when XDPTK returns ftUnknown
	public static final int UnsupportedFileFormat					= MAKE_RES_ID (SVC_XFA, 232 );

//	 XFA Href Service
	public static final int XFAHrefServiceException					= MAKE_RES_ID (SVC_XFA, 233 );
	public static final int XFAHrefStoreException					= MAKE_RES_ID (SVC_XFA, 234 );

//	XMLFormAgentService
	public static final int TemplateCacheTraceHelp					= MAKE_RES_ID (SVC_XFA, 235 );
	public static final int TemplateCacheTraceOnLoad				= MAKE_RES_ID (SVC_XFA, 236 );
	public static final int TemplateCacheTraceFoundInCache			= MAKE_RES_ID (SVC_XFA, 237 );
	public static final int TemplateCacheTraceUsingCachedTemplate	= MAKE_RES_ID (SVC_XFA, 238 );
	public static final int TemplateCacheTraceNotFoundInCache		= MAKE_RES_ID (SVC_XFA, 239 );
	
//	 XFA layout
	public static final int LayoutUnresolvedXFAEmbedExpression		= MAKE_RES_ID (SVC_XFA, 240 );
	public static final int LayoutCyclicalXFAEmbedExpression		= MAKE_RES_ID (SVC_XFA, 241 );
	public static final int LayoutHiddenContainerWarning			= MAKE_RES_ID (SVC_XFA, 242 );

//	 XDC Add Font Agent
	public static final int XDCAddFontNoInputXDC					= MAKE_RES_ID (SVC_XFA, 243 );
	public static final int XDCAddFontNoOutputXDC					= MAKE_RES_ID (SVC_XFA, 244 );
	public static final int XDCAddFontNoFontDirectory				= MAKE_RES_ID (SVC_XFA, 245 );
	public static final int XDCAddFontAddedFont						= MAKE_RES_ID (SVC_XFA, 246 );
	public static final int XDCAddFontFailedToAddFont				= MAKE_RES_ID (SVC_XFA, 247 );

//	XFA layout
	public static final int LayoutInvalidColumnWidth				= MAKE_RES_ID (SVC_XFA, 248);

//	 XFA Form
	public static final int FormInvalidDataRef						= MAKE_RES_ID (SVC_XFA, 249 );

	public static final int LayoutInvalidColSpan					= MAKE_RES_ID (SVC_XFA, 250);
	public static final int LayoutAutoCalcColumnWidthFailure		= MAKE_RES_ID (SVC_XFA, 251);
	public static final int LayoutBreakToBlankException				= MAKE_RES_ID (SVC_XFA, 252);

//	 xfascriptmonitor
	public static final int ScriptMonitorTitle						= MAKE_RES_ID (SVC_XFA, 253);
	public static final int ScriptMonitorOptions					= MAKE_RES_ID (SVC_XFA, 254);
	public static final int ScriptMonitorDisplayException			= MAKE_RES_ID (SVC_XFA, 255);

	public static final int AGMInitializePortException				= MAKE_RES_ID (SVC_XFA, 256);

	public static final int LayoutInvalidSplitNonContigous			= MAKE_RES_ID (SVC_XFA, 257);

	public static final int XFTVT_InvalidOccurrence					= MAKE_RES_ID (SVC_XFA, 258);
	
// 	Layout
	public static final int LayoutInitContentException				= MAKE_RES_ID (SVC_XFA, 259);
	public static final int LayoutBreakEvenInSimplex				= MAKE_RES_ID (SVC_XFA, 260);

//	 More trace messages
	public static final int FontAddEncodingTrace					= MAKE_RES_ID (SVC_XFA, 261);
	
//	XFA layout
	public static final int LayoutBreakEvenOddMismatchException		= MAKE_RES_ID (SVC_XFA, 262);

//	XFA layout		
	public static final int LayoutResolveKeepTrace					= MAKE_RES_ID (SVC_XFA, 263);
	public static final int LayoutUnsupportedKeepValue				= MAKE_RES_ID (SVC_XFA, 264);
	public static final int LayoutInvalidKeep						= MAKE_RES_ID (SVC_XFA, 265);

//	 xfa rendering agent
	public static final int AREInitializeException					= MAKE_RES_ID (SVC_XFA, 266);

//	XFAFormModelImpl
	public static final int ContextNodeNotFound						= MAKE_RES_ID (SVC_XFA, 267);

//	 CoretechLib tracing
	public static final int CoretechTraceDesc						= MAKE_RES_ID (SVC_XFA, 268);
	public static final int CoretechInitLibsTrace					= MAKE_RES_ID (SVC_XFA, 269);
	public static final int CoretechRenderInitLibsTrace				= MAKE_RES_ID (SVC_XFA, 270);
	public static final int CoretechTermLibsTrace					= MAKE_RES_ID (SVC_XFA, 271);
	public static final int CoretechTermRenderLibsTrace				= MAKE_RES_ID (SVC_XFA, 272);

//	 xfa rendering agent
	public static final int ConnectionSetFileNotFound				= MAKE_RES_ID (SVC_XFA, 273);
	public static final int ConnectionSetFileNotSpecified			= MAKE_RES_ID (SVC_XFA, 274);

//	xfa scripthandler
	public static final int ScriptHandlerError						= MAKE_RES_ID(SVC_XFA,	275);

//	 xdc
	public static final int InvalidOutputEncoding					= MAKE_RES_ID (SVC_XFA, 276);

//	 XFAImageService
	public static final int XFAImageServiceException				= MAKE_RES_ID (SVC_XFA, 277);
	public static final int UnsupportedTransferEncoding				= MAKE_RES_ID (SVC_XFA, 278);

//	 xfa form
	public static final int FormSubmitCancelled						= MAKE_RES_ID (SVC_XFA, 279);
	public static final int FormStateContextNodeNotFound			= MAKE_RES_ID (SVC_XFA, 280);

//	xfa
	public static final int XFANodeReplaceWarning					= MAKE_RES_ID (SVC_XFA, 281);
	public static final int DuplicateIdException                    = MAKE_RES_ID (SVC_XFA, 282);

//	 XFAImageService
	public static final int XFAImageServiceGetWidthWarning			= MAKE_RES_ID(SVC_XFA, 283);
	public static final int XFAImageServiceGetHeightWarning			= MAKE_RES_ID(SVC_XFA, 284);

//	 more trace messages
	public static final int ScriptTraceTime							= MAKE_RES_ID(SVC_XFA, 285);

//	 xaf plugin message
	public static final int MessageLimitExceeded					= MAKE_RES_ID(SVC_XFA, 286);

// 287
// 288
	
	public static final int InputTrayNotFound						= MAKE_RES_ID(SVC_XFA, 289);
	
// 	more xfa merge trace (incremental merge)
	public static final int IncrementalMergeDisabledTrace			= MAKE_RES_ID (SVC_XFA, 290 );
	public static final int IncrementalMergeSucceededTrace			= MAKE_RES_ID (SVC_XFA, 291 );
	public static final int IncrementalMergeFullMergeTrace			= MAKE_RES_ID (SVC_XFA, 292 );
	
//	field mdp
	public static final int InvalidManifestException				= MAKE_RES_ID(SVC_XFA, 293);
	
	public static final int FormPrintCancelled						= MAKE_RES_ID(SVC_XFA, 294);
	public static final int FormValidationForSaveFailed				= MAKE_RES_ID(SVC_XFA, 295);
	
	// execute
	public static final int FormExecuteCancelled					= MAKE_RES_ID (SVC_XFA, 296 );
	
// XFAImageService
	public static final int XFAImageServiceMPSException				= MAKE_RES_ID(SVC_XFA, 297);
	
//	layout
	public static final int LayoutBacktrackIncompatibleContentArea	= MAKE_RES_ID(SVC_XFA, 298);

//	 version control
	public static final int  InvalidChildVersionException           = MAKE_RES_ID(SVC_XFA, 299);
	public static final int  InvalidAttributeVersionException       = MAKE_RES_ID(SVC_XFA, 300);
	public static final int  DeprecatedChildException               = MAKE_RES_ID(SVC_XFA, 301);
	public static final int  DeprecatedAttributeException           = MAKE_RES_ID(SVC_XFA, 302);
	
	public static final int  InvalidModelVersionException           = MAKE_RES_ID(SVC_XFA, 303);
	public static final int  InvalidScriptVersionException          = MAKE_RES_ID(SVC_XFA, 304);
	public static final int  InvalidModelVersionUpdate              = MAKE_RES_ID(SVC_XFA, 305);
	
	// xfa core again
	public static final int CircularProtoException                  = MAKE_RES_ID(SVC_XFA, 306);
	public static final int IncrementalDataLoadException			= MAKE_RES_ID(SVC_XFA, 307);

	// SourceSet
	public static final int XFASourceNoQuerySpecifiedException		= MAKE_RES_ID(SVC_XFA, 308);
	public static final int XFASourceNoCommandSpecifiedException	= MAKE_RES_ID(SVC_XFA, 309);
	public static final int XFASourceNoRecordSetException			= MAKE_RES_ID(SVC_XFA, 310);
	
	// DataValue
	public static final int CantSetTransferEncoding					= MAKE_RES_ID(SVC_XFA, 311);
	public static final int CantSetHref								= MAKE_RES_ID(SVC_XFA, 312);
	
//	trace
	public static final int TraceFormLocale							= MAKE_RES_ID(SVC_XFA, 313);

//	XFA
	public static final int FragmentIDNotSelfContained				= MAKE_RES_ID(SVC_XFA, 314);	
	public static final int CannotConvertSOMToID					= MAKE_RES_ID(SVC_XFA, 315);
	
//	XFATemplate
	public static final int UnRecognizedNameSpaceWarning			= MAKE_RES_ID(SVC_XFA, 316);

//	XFAEventPseudoModel
	public static final int FormOpenCancelled						= MAKE_RES_ID(SVC_XFA, 317);
	
//	XFA Permissions
	public static final int PermissionsViolationException			= MAKE_RES_ID(SVC_XFA, 318);
	public static final int PermissionsViolationExceptionProperty	= MAKE_RES_ID(SVC_XFA, 319);
	public static final int PermissionsViolationExceptionMethod		= MAKE_RES_ID(SVC_XFA, 320);
	
// XFAContent
	public static final int TypeMismatch							= MAKE_RES_ID(SVC_XFA, 321);
	
// form
	public static final int ValidationFailed						= MAKE_RES_ID(SVC_XFA, 322);

// xfa layout (boxmodel and barcode)
//	public static final int BarcodeTooSmall							= MAKE_RES_ID(SVC_XFA, 323);
//	public static final int BarcodeTooBig							= MAKE_RES_ID(SVC_XFA, 324);
	
// v3.1 limitations with Fiber, associations and mergeMode="matchTemplate"
//	public static final int InteractiveNotAllowed					= MAKE_RES_ID(SVC_XFA, 325);
	public static final int InstanceManagmentNotAllowed				= MAKE_RES_ID(SVC_XFA, 326);

	
	
//	 DOM - uncomment as required.
//	public static final int DOM_INDEX_SIZE_ERR						= MAKE_RES_ID (SVC_DOM,  1);
//	public static final int DOM_HIERARCHY_REQUEST_ERR				= MAKE_RES_ID (SVC_DOM,  3);
//	public static final int DOM_WRONG_DOCUMENT_ERR					= MAKE_RES_ID (SVC_DOM,  4);
//	public static final int DOM_INVALID_CHARACTER_ERR				= MAKE_RES_ID (SVC_DOM,  5);
//	public static final int DOM_NO_DATA_ALLOWED_ERR					= MAKE_RES_ID (SVC_DOM,  6);
	public static final int DOM_NO_MODIFICATION_ALLOWED_ERR			= MAKE_RES_ID (SVC_DOM,  7);
//	public static final int DOM_NOT_FOUND_ERR						= MAKE_RES_ID (SVC_DOM,  8);
//	public static final int DOM_INUSE_ATTRIBUTE_ERR		 			= MAKE_RES_ID (SVC_DOM,  10);
	public static final int DOM_DUPLICATE_ID_ERR		 			= MAKE_RES_ID (SVC_DOM,  11);
	public static final int DOM_MODIFY_ID_ERR		 				= MAKE_RES_ID (SVC_DOM,  12);
//	public static final int DOM_TRANSFORMED_FILE_ERR				= MAKE_RES_ID (SVC_DOM,  13);
	public static final int DOM_NODE_NAME_ERR						= MAKE_RES_ID (SVC_DOM,  14);
//	public static final int DOM_SABLOTRON_UNAVAIL_ERR				= MAKE_RES_ID (SVC_DOM,  15);
	public static final int EXPAT_ERROR								= MAKE_RES_ID (SVC_DOM, 100);
	public static final int NAMESPACE_PREFIX_ERR                    = MAKE_RES_ID (SVC_DOM, 203);
	public static final int XPATH_ERROR			                    = MAKE_RES_ID (SVC_DOM, 204);


// FormCalc resource codes
	public static final int FC_ERR_SYNTAX               			= MAKE_RES_ID(SVC_FC,  0);
	public static final int FC_ERR_PARAMETER            			= MAKE_RES_ID(SVC_FC,  1);
	public static final int FC_ERR_ARITHMETIC           			= MAKE_RES_ID(SVC_FC,  2);
	public static final int FC_ERR_ACCESSOR             			= MAKE_RES_ID(SVC_FC,  3);
	public static final int FC_ERR_SURROGATE 						= MAKE_RES_ID(SVC_FC,  4);
	public static final int FC_ERR_LOOP             				= MAKE_RES_ID(SVC_FC,  5);
	public static final int FC_ERR_LOOP_ARGS           				= MAKE_RES_ID(SVC_FC,  6);
	public static final int FC_ERR_VAR_DUP             				= MAKE_RES_ID(SVC_FC,  7);
	public static final int FC_ERR_FUNC_DUP             			= MAKE_RES_ID(SVC_FC, 10);
	public static final int FC_ERR_FUNC_DECL						= MAKE_RES_ID(SVC_FC, 11);
	public static final int FC_ERR_REF_NULL             			= MAKE_RES_ID(SVC_FC, 12);
	public static final int FC_ERR_VAR_USED             			= MAKE_RES_ID(SVC_FC, 13);
	public static final int FC_ERR_REF_USED             			= MAKE_RES_ID(SVC_FC, 14);
	public static final int FC_SYS_ERR_REENT        				= MAKE_RES_ID(SVC_FC, 15);
	public static final int FC_ERR_FUNC_UNKN        				= MAKE_RES_ID(SVC_FC, 16);
	public static final int FC_ERR_FUNC_USED        				= MAKE_RES_ID(SVC_FC, 17);
	public static final int FC_ERR_NO_EXPR  	 					= MAKE_RES_ID(SVC_FC, 18);
	public static final int FC_ERR_INTERRUPTED 						= MAKE_RES_ID(SVC_FC, 19);

// Protocol resource codes
	public static final int PROTOCOL_ERR_SYS						= MAKE_RES_ID(SVC_PROTOCOL, 2);
	public static final int PROTOCOL_ERR_POST						= MAKE_RES_ID(SVC_PROTOCOL, 3);
	public static final int PROTOCOL_ERR_READ						= MAKE_RES_ID(SVC_PROTOCOL, 4);
	public static final int PROTOCOL_ERR_WRITE						= MAKE_RES_ID(SVC_PROTOCOL, 5);


//	 XFA locale set - has its own subrange!  
	public static final int	LocaleUnknown							= MAKE_RES_ID (SVC_XFA_LOCALESET, 0);
	public static final int	LocaleDataIncomplete					= MAKE_RES_ID (SVC_XFA_LOCALESET, 1);


	/*
	 * Disallow instance of this class.
	 */
    private ResId() {
    }

}
