/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2008 Adobe Systems Incorporated
 * All Rights Reserved
 *
 * Notice: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa.wsdl;

import com.adobe.xfa.Element;

/**
 * @exclude from published api.
 */
public class WSDLExten extends WSDLNode {
	public static final int EX_TYPE_UNKNOWN = 1;
	public static final int EX_TYPE_SOAP_BINDING = 2;
	public static final int EX_TYPE_SOAP_OPERATION = 3;
	public static final int EX_TYPE_SOAP_BODY = 4;
	public static final int EX_TYPE_SOAP_FAULT = 5;
	public static final int EX_TYPE_SOAP_HEADER = 6;
	public static final int EX_TYPE_SOAP_HEADER_DEFAULT = 7;
	public static final int EX_TYPE_SOAP_ADDRESS = 8;
	public static final int EX_TYPE_HTTP_BINDING = 9;
	public static final int EX_TYPE_HTTP_OPERATION = 10;
	public static final int EX_TYPE_HTTP_ADDRESS = 11;
	public static final int EX_TYPE_HTTP_URL_ENCODED = 12;
	public static final int EX_TYPE_HTTP_URL_REPLACEMENT = 13;
	public static final int EX_TYPE_MIME_CONTENT = 14;
	public static final int EX_TYPE_MIME_MULTIPARTRELATED = 15;
	public static final int EX_TYPE_MIME_XML = 16;

// every thing below this comment is not currently implemented.
	public static final int EX_ATTR_SOAP_STYLE = 0;
	public static final int EX_ATTR_SOAP_TRANSPORT = 1;
	public static final int EX_ATTR_SOAP_SOAPACTION = 2;
	public static final int EX_ATTR_SOAP_PARTS = 3;
	public static final int EX_ATTR_SOAP_PART = 4;
	public static final int EX_ATTR_SOAP_USE = 5;
	public static final int EX_ATTR_SOAP_ENCODINGSTYLE = 6;
	public static final int EX_ATTR_SOAP_MESSAGE = 7;
	public static final int EX_ATTR_SOAP_LOCATION = 8;
	public static final int EX_ATTR_MAX = 9;

	private static final String[] mAttrList = {
		WSDL.STYLE,
		WSDL.TRANSPORT,
		WSDL.SOAPACTION,
		WSDL.PARTS,
		WSDL.PART,
		WSDL.USE,
		WSDL.ENCODINGSTYLE,
		WSDL.MESSAGE,
		WSDL.LOCATION
	};

	private int meExtenType = EX_TYPE_UNKNOWN;

/**
 * Default constructor. Yields an empty <code>WSDLExten</code> (NULL wrapper).
 */
	public WSDLExten (WSDLDocument poDocument, Element oSrc) {
		super (poDocument, oSrc, WSDL_EXTEN);
	}

/*
 * Clone a WSDLExten.
 * @param bDeep - if true then clone recursively.
 */
	// Note: cloneNode() commented out.  In C++, it is not used by XFA,
	// Designer or Acrobat.  There is currently no requirement for it in
	// Java.  The ported code below is untested.  This code could be restored
	// if a requirement arose.
//	public WSDLExten cloneNode (boolean bDeep) {
//		WSDLExten poNewNode = new WSDLExten (getWSDLOwnerDocument(), getDomNode());
//		cloneNodeHelper (poNewNode, bDeep);
//		poNewNode.meExtenType = meExtenType;
//		return poNewNode;
//	}

/**
 * The code representing the type of object represented by this
 *   <code>WSDLExten</code>
 * @return A code representing the type of object represented by this
 *   <code>WSDLExten</code>
 */
	public int getExtenType () {
		return meExtenType;
	}

	void setExtenType (int extenType) {
		meExtenType = extenType;
	}

/**
 * Gets a <code>String</code> containing the named attribute of this node (if it
 * is has the named attribute or Sting::EmptyString() otherwise.
 */
	public String getExtenAttribute (int eExtenAttribute) {
		return getWSDLAttribute (mAttrList, eExtenAttribute);
	}
}
