// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2012 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================
package com.adobe.xmp.core;

/**
 * Exception class for all exceptions in XMPCore2.
 */
public class XMPException extends Exception
{
	private static final long serialVersionUID = -7198438977309224764L;

	@SuppressWarnings("javadoc")
	public XMPException()
	{
	}

	/**
	 * Constructs an exception with a message.
	 * @param message the message
	 */
	public XMPException(String message)
	{
	    super( message );
	}

	/**
	 * Constructs an exception with a <code>Throwable</code>
	 * @param cause the exception source
	 */
	public XMPException(Throwable cause)
	{
	    super( cause );
	}

	/**
	 * Constructs an exception with a message, and a <code>Throwable</code>
	 * @param message the error message.
	 * @param cause the exception source
	 */
	public XMPException(String message, Throwable cause)
	{
	    super( message, cause );
	}

}
