// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2012 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================
package com.adobe.xmp.core;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.adobe.xmp.core.impl.XMPMetadataImpl;

/**
 * A Factory to create a new XMPMetadata tree
 *
 */
public class XMPMetadataFactory
{
	/** cache for version string */
	private static String versionString = null;
	
	/**
	 * A factory method to create a new instance of an empty XMPMetadata tree 
	 * @return The instance of the newly created empty XMPMetadata object
	 */
	public static XMPMetadata create()
	{
		return new XMPMetadataImpl();
	}

	
	/**
	 * Provides a version string for the library, that is serialized into the XMP packet.
	 * @return Returns a human readable Version string.
	 */
	public static String getVersionString()
	{
		if (versionString == null)
		{
			String bundleVersion;
			try
			{
				Enumeration<URL> resources = XMPMetadataFactory.class
						.getClassLoader().getResources("META-INF/MANIFEST.MF");

				while (resources.hasMoreElements())
				{
					Manifest manifest = new Manifest(resources.nextElement()
							.openStream());
					Attributes attrs = manifest.getMainAttributes();
					// find the correct manifest
					if ("com.adobe.xmp.core".equals(attrs
							.getValue("Bundle-SymbolicName")))
					{
						if (attrs.getValue("Bundle-Version") != null)
						{
							bundleVersion = attrs.getValue("Bundle-Version");
							Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+).*");
							Matcher matcher = pattern.matcher(bundleVersion);
							// If version is of expected format.
							if (matcher.find())
							{
								versionString = bundleVersion;
								break;
							}
						}
					}
				}
			}
			catch (IOException E)
			{
				// EMPTY
			}
		}
		return versionString;
	}
}
