// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2011 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.schema.model;

import java.io.Serializable;

/**
 * Marker Interface for all property rules.
 * All rules of a property have to be processed with the "OR" operator,
 * except the logical rule is used.
 * 
 * @author Stefan Makswit
 */
public interface TypeRule extends Serializable
{
	/**
	 * Logical operators
	 */
	public enum LogicalOperator
	{
		/** logical AND */
		AND,
		/** logical OR */
		OR,
		/** logical NOT */
		NOT
	}
	
	
	/**
	 * Comparison operators, used for Integer, Real, 
	 * as well as array and string length
	 */
	public enum ComparisonOperator
	{
		/** Equals works also for Text */
		EQUALS, 
		/** compare less */
		LESS,
		/** compare less or equals */
		LESS_EQUALS,
		/** compare greater */
		GREATER,
		/** compare equals */
		GREATER_EQUALS
	}
	
	
	/**
	 * @param schemaVisitor a visitor that implements the <code>SchemaVisitor</code>-interface
	 */
	void accept(SchemaVisitor schemaVisitor) throws XMPSchemaException;
}
